/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.util.Map;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class Insert
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("match");
    private static final QName _position = new QName("position");
    private ReadablePipe insertion = null;
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Map<QName, RuntimeValue> inScopeOptions = null;
    private ProcessMatch matcher = null;
    private String position = null;
    private String matchPattern = null;

    public Insert(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else {
            this.insertion = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.position = this.getOption(_position).getString();
        XdmNode xdmNode = this.source.read();
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(xdmNode, this.getOption(_match));
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(25);
    }

    @Override
    public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(25);
    }

    @Override
    public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
        if ("before".equals(this.position)) {
            this.doInsert();
        }
        this.matcher.addStartElement(xdmNode);
        this.matcher.addAttributes(xdmNode);
        this.matcher.startContent();
        if ("first-child".equals(this.position)) {
            this.doInsert();
        }
        return true;
    }

    @Override
    public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
        if ("last-child".equals(this.position)) {
            this.doInsert();
        }
        this.matcher.addEndElement();
        if ("after".equals(this.position)) {
            this.doInsert();
        }
    }

    @Override
    public void processText(XdmNode xdmNode) throws SaxonApiException {
        this.process(xdmNode);
    }

    @Override
    public void processComment(XdmNode xdmNode) throws SaxonApiException {
        this.process(xdmNode);
    }

    @Override
    public void processPI(XdmNode xdmNode) throws SaxonApiException {
        this.process(xdmNode);
    }

    private void process(XdmNode xdmNode) throws SaxonApiException {
        if ("before".equals(this.position)) {
            this.doInsert();
        }
        if (xdmNode.getNodeKind() == XdmNodeKind.COMMENT) {
            this.matcher.addComment(xdmNode.getStringValue());
        } else if (xdmNode.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
            this.matcher.addPI(xdmNode.getNodeName().getLocalName(), xdmNode.getStringValue());
        } else if (xdmNode.getNodeKind() == XdmNodeKind.TEXT) {
            this.matcher.addText(xdmNode.getStringValue());
        } else {
            throw new IllegalArgumentException("What kind of node was that!?");
        }
        if ("after".equals(this.position)) {
            this.doInsert();
        }
        if ("first-child".equals(this.position) || "last-child".equals(this.position)) {
            throw XProcException.stepError(25);
        }
    }

    @Override
    public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    private void doInsert() throws SaxonApiException {
        while (this.insertion.moreDocuments()) {
            XdmNode xdmNode = this.insertion.read();
            XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
            while (xdmSequenceIterator.hasNext()) {
                XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                this.matcher.addSubtree(xdmNode2);
            }
        }
        this.insertion.resetReader();
    }
}

