/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import org.xmlresolver.Catalog;
import org.xmlresolver.NamespaceResolver;
import org.xmlresolver.Resource;
import org.xmlresolver.ResourceResolver;

public class Resolver
implements URIResolver,
EntityResolver,
EntityResolver2,
NamespaceResolver,
LSResourceResolver {
    private static Logger logger = Logger.getLogger("org.xmlresolver.Resolver");
    ResourceResolver resolver = null;

    public Resolver() {
        this.resolver = new ResourceResolver();
        this.resolver.setEntityResolver(this);
    }

    public Resolver(Catalog catalog) {
        this.resolver = new ResourceResolver(catalog);
        this.resolver.setEntityResolver(this);
    }

    public Resolver(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public Catalog getCatalog() {
        return this.resolver.getCatalog();
    }

    public Resource resolveResource(String href, String base) {
        if (href == null || "".equals(href)) {
            href = base;
            base = null;
        }
        logger.fine("resolveResource(" + href + "," + base + ")");
        Resource rsrc = this.resolver.resolveURI(href, base);
        if (rsrc == null) {
            logger.fine("  not resolved locally");
        } else {
            logger.fine("  resolved locally: " + rsrc.uri());
        }
        return rsrc;
    }

    public Source resolve(String href, String base) throws TransformerException {
        Resource rsrc = this.resolveResource(href, base);
        if (rsrc == null) {
            return null;
        }
        SAXSource source = new SAXSource(new InputSource(rsrc.body()));
        source.setSystemId(rsrc.uri());
        return source;
    }

    public Source resolveNamespace(String uri, String nature, String purpose) throws TransformerException {
        logger.fine("resolveNamespace(" + uri + "," + nature + "," + purpose + ")");
        Resource rsrc = this.resolver.resolveNamespaceURI(uri, nature, purpose);
        if (rsrc == null) {
            logger.fine("  not resolved locally");
            return null;
        }
        logger.fine("  resolved locally: " + rsrc.uri());
        SAXSource source = new SAXSource(new InputSource(rsrc.body()));
        source.setSystemId(rsrc.uri());
        return source;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        logger.fine("resolveEntity(" + publicId + "," + systemId + ")");
        Resource rsrc = this.resolver.resolvePublic(systemId, publicId);
        if (rsrc == null) {
            logger.fine("  not resolved locally");
            return null;
        }
        logger.fine("  resolved locally: " + rsrc.uri());
        InputSource source = new InputSource(rsrc.body());
        source.setSystemId(rsrc.uri());
        return source;
    }

    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        logger.fine("getExternalSubset(" + name + "," + baseURI + ")");
        Resource rsrc = this.resolver.resolveDoctype(name);
        if (rsrc == null) {
            logger.fine("  not resolved locally");
            return null;
        }
        logger.fine("  resolved locally: " + rsrc.uri());
        InputSource source = new InputSource(rsrc.body());
        source.setSystemId(rsrc.uri());
        return source;
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        String absSystem = null;
        if (baseURI != null) {
            try {
                URI auri = new URI(baseURI);
                auri = auri.resolve(new URI(systemId));
                absSystem = auri.toURL().toString();
            }
            catch (URISyntaxException use) {
            }
            catch (MalformedURLException mue) {
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        logger.fine("resolveEntity(" + name + "," + publicId + "," + absSystem + ")");
        Resource rsrc = this.resolver.resolveEntity(name, publicId, absSystem);
        if (rsrc == null) {
            logger.fine("  not resolved locally");
            return null;
        }
        logger.fine("  resolved locally: " + rsrc.uri());
        InputSource source = new InputSource(rsrc.body());
        source.setSystemId(rsrc.uri());
        return source;
    }

    public LSInput resolveResource(String type, String namespace, String publicId, String systemId, String baseURI) {
        String absSystem = null;
        if (baseURI != null) {
            try {
                URI auri = new URI(baseURI);
                auri = auri.resolve(new URI(systemId));
                absSystem = auri.toURL().toString();
            }
            catch (URISyntaxException use) {
            }
            catch (MalformedURLException mue) {
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        Resource rsrc = null;
        if ("http://www.w3.org/TR/REC-xml".equals(type)) {
            logger.fine("resolveResource(XML," + publicId + "," + absSystem + ")");
            rsrc = this.resolver.resolvePublic(absSystem, publicId);
        } else if ("http://www.w3.org/2001/XMLSchema".equals(type)) {
            logger.fine("resolveResource(XMLSchema," + namespace + "," + absSystem + ")");
            rsrc = this.resolver.resolveURI(absSystem, baseURI);
        } else {
            return null;
        }
        if (rsrc == null) {
            logger.fine("  not resolved locally");
            return null;
        }
        logger.fine("  resolved locally: " + rsrc.uri());
        return new ResolverLSInput(rsrc, publicId);
    }

    class ResolverLSInput
    implements LSInput {
        Resource rsrc = null;
        String publicId = null;

        public ResolverLSInput(Resource rsrc, String publicId) {
            this.rsrc = rsrc;
            this.publicId = publicId;
        }

        public Reader getCharacterStream() {
            return new InputStreamReader(this.rsrc.body());
        }

        public void setCharacterStream(Reader reader) {
            throw new UnsupportedOperationException("Can't set character stream on resolver LSInput");
        }

        public InputStream getByteStream() {
            return this.rsrc.body();
        }

        public void setByteStream(InputStream inputStream) {
            throw new UnsupportedOperationException("Can't set byte stream on resolver LSInput");
        }

        public String getStringData() {
            return null;
        }

        public void setStringData(String string) {
            throw new UnsupportedOperationException("Can't set string data on resolver LSInput");
        }

        public String getSystemId() {
            return this.rsrc.uri();
        }

        public void setSystemId(String string) {
            throw new UnsupportedOperationException("Can't set system ID on resolver LSInput");
        }

        public String getPublicId() {
            return this.publicId;
        }

        public void setPublicId(String string) {
            throw new UnsupportedOperationException("Can't set public ID on resolver LSInput");
        }

        public String getBaseURI() {
            return this.rsrc.uri();
        }

        public void setBaseURI(String string) {
            throw new UnsupportedOperationException("Can't set base URI on resolver LSInput");
        }

        public String getEncoding() {
            return null;
        }

        public void setEncoding(String string) {
            throw new UnsupportedOperationException("Can't set encoding on resolver LSInput");
        }

        public boolean getCertifiedText() {
            return false;
        }

        public void setCertifiedText(boolean b) {
            throw new UnsupportedOperationException("Can't set certified text on resolver LSInput");
        }
    }
}

