/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net.httpclient;

import net.sf.antcontrib.net.httpclient.Credentials;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;

public class HttpStateType
extends DataType {
    private HttpState state;

    public HttpStateType(Project p) {
        this.setProject(p);
        this.state = new HttpState();
    }

    public HttpState getState() {
        if (this.isReference()) {
            return this.getRef().getState();
        }
        return this.state;
    }

    protected HttpStateType getRef() {
        return (HttpStateType)((Object)super.getCheckedRef(HttpStateType.class, "http-state"));
    }

    public void addConfiguredCredentials(Credentials credentials) {
        if (this.isReference()) {
            this.tooManyAttributes();
        }
        AuthScope scope = new AuthScope(credentials.getHost(), credentials.getPort(), credentials.getRealm(), credentials.getScheme());
        UsernamePasswordCredentials c = new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
        this.state.setCredentials(scope, (org.apache.commons.httpclient.Credentials)c);
    }

    public void addConfiguredProxyCredentials(Credentials credentials) {
        if (this.isReference()) {
            this.tooManyAttributes();
        }
        AuthScope scope = new AuthScope(credentials.getHost(), credentials.getPort(), credentials.getRealm(), credentials.getScheme());
        UsernamePasswordCredentials c = new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
        this.state.setProxyCredentials(scope, (org.apache.commons.httpclient.Credentials)c);
    }

    public void addConfiguredCookie(Cookie cookie) {
        if (this.isReference()) {
            this.tooManyAttributes();
        }
        this.state.addCookie(cookie);
    }
}

