/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Sequential;

public class Switch
extends Task {
    private String value;
    private Vector cases = new Vector();
    private Sequential defaultCase;
    private boolean caseInsensitive;

    public void execute() throws BuildException {
        if (this.value == null) {
            throw new BuildException("Value is missing");
        }
        if (this.cases.size() == 0 && this.defaultCase == null) {
            throw new BuildException("No cases supplied");
        }
        Sequential selectedCase = this.defaultCase;
        int sz = this.cases.size();
        for (int i = 0; i < sz; ++i) {
            Case c = (Case)((Object)this.cases.elementAt(i));
            String cvalue = c.value;
            if (cvalue == null) {
                throw new BuildException("Value is required for case.");
            }
            String mvalue = this.value;
            if (this.caseInsensitive) {
                cvalue = cvalue.toUpperCase();
                mvalue = mvalue.toUpperCase();
            }
            if (!cvalue.equals(mvalue) || c == this.defaultCase) continue;
            selectedCase = c;
        }
        if (selectedCase == null) {
            throw new BuildException("No case matched the value " + this.value + " and no default has been specified.");
        }
        selectedCase.perform();
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setCaseInsensitive(boolean c) {
        this.caseInsensitive = c;
    }

    public Case createCase() throws BuildException {
        Case res = new Case();
        this.cases.addElement(res);
        return res;
    }

    public void addDefault(Sequential res) throws BuildException {
        if (this.defaultCase != null) {
            throw new BuildException("Cannot specify multiple default cases");
        }
        this.defaultCase = res;
    }

    public final class Case
    extends Sequential {
        private String value;

        public void setValue(String value) {
            this.value = value;
        }

        public void execute() throws BuildException {
            super.execute();
        }

        public boolean equals(Object o) {
            boolean res = false;
            Case c = (Case)((Object)o);
            if (c.value.equals(this.value)) {
                res = true;
            }
            return res;
        }
    }
}

