# SPDX-License-Identifier: Apache-2.0
# Copyright 2013-2021 The Meson development team

from __future__ import annotations

import typing as T

from .baseobjects import MesonInterpreterObject

if T.TYPE_CHECKING:
    from .baseobjects import TYPE_var, TYPE_kwargs

class Disabler(MesonInterpreterObject):
    def method_call(self, method_name: str, args: T.List[TYPE_var], kwargs: TYPE_kwargs) -> TYPE_var:
        if method_name == 'found':
            return False
        return Disabler()

def _is_arg_disabled(arg: T.Any) -> bool:
    if isinstance(arg, Disabler):
        return True
    if isinstance(arg, list):
        for i in arg:
            if _is_arg_disabled(i):
                return True
    return False

def is_disabled(args: T.Sequence[T.Any], kwargs: T.Dict[str, T.Any]) -> bool:
    for i in args:
        if _is_arg_disabled(i):
            return True
    for i in kwargs.values():
        if _is_arg_disabled(i):
            return True
    return False
