/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;

public class XPointerScheme {
    protected QName schemeName = null;
    protected String schemeData = null;
    private static final Pattern rangeRE = Pattern.compile("^.*?=(\\d*)?(,(\\d*)?)?$");
    private static final Pattern lengthRE = Pattern.compile("^length=(\\d+)(,.*)?$");
    private long sp = -1L;
    private long ep = -1L;
    private boolean chars = false;
    private long cp = -1L;
    private long lp = -1L;

    private XPointerScheme() {
    }

    public QName getName() {
        return this.schemeName;
    }

    public String getData() {
        return this.schemeData;
    }

    public XPointerScheme(QName qName, String string) {
        this.schemeName = qName;
        this.schemeData = string;
    }

    public String xpathEquivalent() {
        return null;
    }

    public String textEquivalent() {
        return null;
    }

    public Vector<XdmNode> selectNodes(XProcRuntime xProcRuntime, XdmNode xdmNode, Hashtable<String, String> hashtable) {
        String string = this.xpathEquivalent();
        if (string == null) {
            throw new XProcException("XPointer cannot be used to select nodes: " + this.schemeName + "(" + this.schemeData + ")");
        }
        Vector<XdmNode> vector = new Vector<XdmNode>();
        XPathSelector xPathSelector = null;
        XPathCompiler xPathCompiler = xProcRuntime.getProcessor().newXPathCompiler();
        for (String string2 : hashtable.keySet()) {
            xPathCompiler.declareNamespace(string2, hashtable.get(string2));
        }
        try {
            XPathExecutable xPathExecutable = xPathCompiler.compile(string);
            xPathSelector = xPathExecutable.load();
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
        try {
            xPathSelector.setContextItem((XdmItem)xdmNode);
            for (String string2 : xPathSelector) {
                XdmNode xdmNode2 = null;
                try {
                    xdmNode2 = (XdmNode)string2;
                }
                catch (ClassCastException classCastException) {
                    throw new XProcException("XPointer matched non-node item?: " + this.schemeName + "(" + this.schemeData + ")");
                }
                vector.add(xdmNode2);
            }
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
        return vector;
    }

    public String selectText(InputStreamReader inputStreamReader, int n) {
        String string;
        String string2 = this.textEquivalent();
        if (string2 == null) {
            throw new XProcException("XPointer cannot be used to select text: " + this.schemeName + "(" + this.schemeData + ")");
        }
        String string3 = "";
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(inputStreamReader);
        String[] stringArray = string2.split("\\s*;\\s*");
        for (int i = 1; i < stringArray.length; ++i) {
            int n2;
            string = stringArray[i];
            Matcher matcher = lengthRE.matcher(string);
            if (n < 0 || !matcher.matches() || (n2 = Integer.parseInt(matcher.group(1))) == n) continue;
            throw new IllegalArgumentException("Integrity check failed: " + n2 + " != " + n);
        }
        string2 = stringArray[0];
        string2 = string2.trim();
        this.sp = -1L;
        this.ep = Long.MAX_VALUE;
        this.cp = 0L;
        this.lp = 0L;
        Matcher matcher = rangeRE.matcher(string2);
        if (matcher.matches()) {
            string = matcher.group(1);
            if (string != null && !"".equals(string)) {
                this.sp = Integer.parseInt(string);
            }
            if ((string = matcher.group(3)) != null && !"".equals(string)) {
                this.ep = Integer.parseInt(string);
            }
        }
        if (string2.startsWith("char=")) {
            this.chars = true;
        } else if (string2.startsWith("line=")) {
            this.chars = false;
        } else {
            throw new XProcException("Unparseable XPointer: " + this.schemeName + "(" + this.schemeData + ")");
        }
        try {
            while ((string = bufferedReader.readLine()) != null) {
                if (this.chars) {
                    string3 = string3 + this.selectChars(string);
                    continue;
                }
                string3 = string3 + this.selectLines(string);
            }
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        return string3;
    }

    private String selectChars(String string) {
        String string2 = "";
        long l = this.cp + (long)string.length() + 1L;
        if (this.cp < this.sp && l > this.sp) {
            string = string.substring((int)(this.sp - this.cp));
            this.cp = this.sp;
        }
        if (this.cp >= this.sp && this.cp < this.ep) {
            long l2 = this.ep - this.cp;
            if (l2 > (long)string.length()) {
                string2 = string + "\n";
                this.cp = l;
            } else {
                string2 = string2 + string.substring(0, (int)l2);
                this.cp += l2;
            }
        }
        this.cp = l;
        return string2;
    }

    private String selectLines(String string) {
        String string2 = "";
        if (this.lp >= this.sp && this.lp < this.ep) {
            string2 = string + "\n";
        }
        ++this.lp;
        return string2;
    }
}

