/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import net.sf.saxon.event.BuilderMonitor;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.linked.ParentNodeImpl;

public class LinkedBuilderMonitor
extends BuilderMonitor {
    private LinkedTreeBuilder builder;
    private int mark = -1;
    private NodeInfo markedNode;

    public LinkedBuilderMonitor(LinkedTreeBuilder builder) {
        this.builder = builder;
        this.setPipelineConfiguration(builder.getPipelineConfiguration());
        this.setUnderlyingReceiver(builder);
    }

    public void markNextNode(int nodeKind) {
        this.mark = nodeKind;
    }

    public void startDocument(int properties) throws XPathException {
        super.startDocument(properties);
        if (this.mark == 9) {
            this.markedNode = this.builder.getCurrentParentNode();
        }
        this.mark = -1;
    }

    public void startContent() throws XPathException {
        super.startContent();
        if (this.mark == 1) {
            this.markedNode = this.builder.getCurrentParentNode();
        }
        this.mark = -1;
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        super.characters(chars, locationId, properties);
        if (this.mark == 3) {
            this.markedNode = this.builder.getCurrentLeafNode();
        }
        this.mark = -1;
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        super.comment(chars, locationId, properties);
        if (this.mark == 8) {
            this.markedNode = this.builder.getCurrentLeafNode();
        }
        this.mark = -1;
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        super.processingInstruction(target, data, locationId, properties);
        if (this.mark == 7) {
            this.markedNode = this.builder.getCurrentLeafNode();
        }
        this.mark = -1;
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        super.attribute(nameCode, typeCode, value, locationId, properties);
        if (this.mark == 2) {
            ParentNodeImpl element = this.builder.getCurrentParentNode();
            this.markedNode = (NodeInfo)element.iterateAxis((byte)2, new NameTest(2, nameCode, element.getNamePool())).next();
            this.mark = -1;
        }
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        super.namespace(namespaceCode, properties);
        if (this.mark == 13) {
            ParentNodeImpl element = this.builder.getCurrentParentNode();
            NamePool pool = element.getNamePool();
            String prefix = pool.getPrefixFromNamespaceCode(namespaceCode);
            this.markedNode = (NodeInfo)element.iterateAxis((byte)8, new NameTest(13, "", prefix, pool)).next();
            this.mark = -1;
        }
    }

    public NodeInfo getMarkedNode() {
        return this.markedNode;
    }
}

