/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.inifile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.antcontrib.inifile.IniProperty;
import net.sf.antcontrib.inifile.IniSection;

public class IniFile {
    private List sections = new ArrayList();
    private Map sectionMap = new HashMap();

    public List getSections() {
        return this.sections;
    }

    public IniSection getSection(String name) {
        return (IniSection)this.sectionMap.get(name);
    }

    public void setSection(IniSection section) {
        IniSection sec = (IniSection)this.sectionMap.get(section.getName());
        if (sec != null) {
            int idx = this.sections.indexOf(sec);
            this.sections.set(idx, section);
        } else {
            this.sections.add(section);
        }
        this.sectionMap.put(section.getName(), section);
    }

    public void removeSection(String name) {
        IniSection sec = (IniSection)this.sectionMap.get(name);
        if (sec != null) {
            int idx = this.sections.indexOf(sec);
            this.sections.remove(idx);
            this.sectionMap.remove(name);
        }
    }

    public String getProperty(String section, String property) {
        IniProperty prop;
        String value = null;
        IniSection sec = this.getSection(section);
        if (sec != null && (prop = sec.getProperty(property)) != null) {
            value = prop.getValue();
        }
        return value;
    }

    public void setProperty(String section, String property, String value) {
        IniSection sec = this.getSection(section);
        if (sec == null) {
            sec = new IniSection(section);
            this.setSection(sec);
        }
        sec.setProperty(new IniProperty(property, value));
    }

    public void removeProperty(String section, String property) {
        IniSection sec = this.getSection(section);
        if (sec != null) {
            sec.removeProperty(property);
        }
    }

    public void write(Writer writer) throws IOException {
        Iterator it = this.sections.iterator();
        IniSection section = null;
        while (it.hasNext()) {
            section = (IniSection)it.next();
            section.write(writer);
            writer.write(System.getProperty("line.separator"));
        }
    }

    public void read(Reader reader) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        IniSection currentSection = new IniSection("NONE");
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.startsWith(";")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                String secName = line.substring(1, line.length() - 1);
                currentSection = this.getSection(secName);
                if (currentSection != null) continue;
                currentSection = new IniSection(secName);
                this.setSection(currentSection);
                continue;
            }
            String name = line;
            String value = "";
            int pos = line.indexOf("=");
            if (pos != -1) {
                name = line.substring(0, pos);
                value = line.substring(pos + 1);
            }
            currentSection.setProperty(new IniProperty(name, value));
        }
    }
}

