/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GermanAnalyzer
extends Analyzer {
    public static final String[] GERMAN_STOP_WORDS = new String[]{"einer", "eine", "eines", "einem", "einen", "der", "die", "das", "dass", "da\u00df", "du", "er", "sie", "es", "was", "wer", "wie", "wir", "und", "oder", "ohne", "mit", "am", "im", "in", "aus", "auf", "ist", "sein", "war", "wird", "ihr", "ihre", "ihres", "als", "f\u00fcr", "von", "mit", "dich", "dir", "mich", "mir", "mein", "sein", "kein", "durch", "wegen", "wird"};
    private Set<?> stopSet;
    private Set<?> exclusionSet;
    private final Version matchVersion;

    public static final Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_SET;
    }

    public GermanAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_SET);
    }

    public GermanAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, (Set<?>)CharArraySet.EMPTY_SET);
    }

    public GermanAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionSet) {
        this.stopSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy(stopwords));
        this.exclusionSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy(stemExclusionSet));
        this.setOverridesTokenStreamMethod(GermanAnalyzer.class);
        this.matchVersion = matchVersion;
    }

    public GermanAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet((String[])stopwords));
    }

    public GermanAnalyzer(Version matchVersion, Map<?, ?> stopwords) {
        this(matchVersion, stopwords.keySet());
    }

    public GermanAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet((File)stopwords));
    }

    public void setStemExclusionTable(String[] exclusionlist) {
        this.exclusionSet = StopFilter.makeStopSet((String[])exclusionlist);
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(Map exclusionlist) {
        this.exclusionSet = new HashSet(exclusionlist.keySet());
        this.setPreviousTokenStream(null);
    }

    public void setStemExclusionTable(File exclusionlist) throws IOException {
        this.exclusionSet = WordlistLoader.getWordSet((File)exclusionlist);
        this.setPreviousTokenStream(null);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(this.matchVersion, reader);
        result = new StandardFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stopSet);
        result = new GermanStemFilter((TokenStream)result, this.exclusionSet);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(this.matchVersion, reader);
            streams.result = new StandardFilter((TokenStream)streams.source);
            streams.result = new LowerCaseFilter(streams.result);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.result, this.stopSet);
            streams.result = new GermanStemFilter(streams.result, this.exclusionSet);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }

    private static class DefaultSetHolder {
        private static final Set<?> DEFAULT_SET = CharArraySet.unmodifiableSet((CharArraySet)new CharArraySet(Arrays.asList(GERMAN_STOP_WORDS), false));

        private DefaultSetHolder() {
        }
    }
}

