/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xmlresolver.Catalog;
import org.xmlresolver.CatalogResult;
import org.xmlresolver.Resource;
import org.xmlresolver.ResourceCache;
import org.xmlresolver.helpers.DOMUtils;

public class ResourceResolver {
    private static Logger logger = Logger.getLogger("org.xmlresolver");
    private static Catalog staticCatalog = new Catalog();
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder builder = null;
    private Catalog catalog = null;
    private ResourceCache cache = null;

    public ResourceResolver() {
        this.init(staticCatalog);
    }

    public ResourceResolver(Catalog catalog) {
        this.init(catalog);
    }

    public void setEntityResolver(EntityResolver resolver) {
        builder.setEntityResolver(resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Catalog catalog) {
        this.catalog = catalog;
        this.cache = catalog.cache();
        DocumentBuilderFactory documentBuilderFactory = factory;
        synchronized (documentBuilderFactory) {
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            if (builder == null) {
                try {
                    builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException pce) {
                    builder = null;
                }
            }
        }
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    private Resource streamResult(CatalogResult resolved) {
        try {
            if (resolved.cached()) {
                return new Resource(resolved.body(), resolved.externalURI(), resolved.contentType());
            }
            return new Resource(resolved.body(), resolved.uri(), resolved.contentType());
        }
        catch (MalformedURLException mue) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private Resource cacheStreamURI(String resolved) {
        URL url = null;
        boolean suppressCT = false;
        try {
            URI uri = new URI(resolved);
            url = uri.toURL();
            String absuriString = url.toString();
            suppressCT = absuriString.startsWith("file:");
            int statusCode = 0;
            InputStream stream = null;
            String contentType = null;
            String rediruriString = absuriString;
            if (absuriString.startsWith("http:") || absuriString.startsWith("https:")) {
                HttpClient client = new HttpClient();
                GetMethod get = new GetMethod(absuriString);
                get.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
                statusCode = client.executeMethod((HttpMethod)get);
                Header contentTypeHeader = get.getResponseHeader("Content-Type");
                HeaderElement[] elems = contentTypeHeader.getElements();
                contentType = elems == null || elems.length == 0 ? "application/octet-stream" : elems[0].getName();
                if (statusCode == 200) {
                    stream = get.getResponseBodyAsStream();
                    rediruriString = get.getURI().toString();
                }
            } else {
                URLConnection connection = url.openConnection();
                connection.connect();
                contentType = connection.getContentType();
                stream = connection.getInputStream();
                statusCode = 200;
            }
            if (statusCode == 200) {
                if (this.cache != null && this.catalog.cacheSchemeURI(this.getScheme(absuriString)) && this.cache.cacheURI(absuriString)) {
                    String localName = this.cache.addURI(absuriString, suppressCT ? null : contentType, stream, rediruriString);
                    File localFile = new File(localName);
                    FileInputStream result = new FileInputStream(localFile);
                    return new Resource(result, rediruriString);
                }
                return new Resource(stream, rediruriString);
            }
            return null;
        }
        catch (URISyntaxException use) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private Resource cacheStreamNamespaceURI(String resolved, String nature, String purpose) {
        URL url = null;
        boolean suppressCT = false;
        try {
            URI uri = new URI(resolved);
            url = uri.toURL();
            String absuriString = url.toString();
            suppressCT = !absuriString.startsWith("file:");
            URLConnection connection = url.openConnection();
            connection.connect();
            if (this.cache != null && this.catalog.cacheSchemeURI(this.getScheme(absuriString)) && this.cache.cacheURI(absuriString)) {
                String localName = this.cache.addNamespaceURI(absuriString, nature, purpose, suppressCT ? null : connection.getContentType(), connection.getInputStream());
                File localFile = new File(localName);
                FileInputStream result = new FileInputStream(localFile);
                return new Resource(result, absuriString);
            }
            return new Resource(connection.getInputStream(), absuriString);
        }
        catch (URISyntaxException use) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private Resource cacheStreamSystem(String resolved, String publicId) {
        URL url = null;
        boolean suppressCT = false;
        try {
            URI uri = new URI(resolved);
            url = uri.toURL();
            String absuriString = url.toString();
            suppressCT = !absuriString.startsWith("file:");
            URLConnection connection = url.openConnection();
            connection.connect();
            if (this.cache != null && this.catalog.cacheSchemeURI(this.getScheme(absuriString)) && this.cache.cacheURI(absuriString)) {
                String contentType = suppressCT ? null : connection.getContentType();
                InputStream is = connection.getInputStream();
                String localName = this.cache.addSystem(absuriString, publicId, contentType, is);
                FileInputStream result = new FileInputStream(new File(localName));
                return new Resource(result, absuriString);
            }
            return new Resource(connection.getInputStream(), absuriString);
        }
        catch (URISyntaxException use) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Resource resolveURI(String href, String base) {
        logger.fine("resolveURI(" + href + "," + base + ")");
        String uri = href;
        CatalogResult resolved = this.catalog.lookupURI(uri);
        boolean skipCache = false;
        if (resolved == null && base != null) {
            try {
                URI auri = new URI(base);
                auri = auri.resolve(new URI(uri));
                uri = auri.toURL().toString();
                resolved = this.catalog.lookupURI(uri);
            }
            catch (URISyntaxException use) {
                resolved = null;
            }
            catch (MalformedURLException mue) {
                resolved = null;
            }
            catch (IllegalArgumentException iae) {
                resolved = null;
                skipCache = true;
            }
        }
        if (resolved == null) {
            if (skipCache) {
                return null;
            }
            return this.cacheStreamURI(uri);
        }
        if (resolved.expired()) {
            return this.cacheStreamURI(uri);
        }
        return this.streamResult(resolved);
    }

    public Resource resolvePublic(String systemId, String publicId) {
        logger.fine("resolvePublic(" + systemId + "," + publicId + ")");
        CatalogResult resolved = this.catalog.lookupPublic(systemId, publicId);
        if (resolved == null || resolved.expired()) {
            return this.cacheStreamSystem(systemId, publicId);
        }
        return this.streamResult(resolved);
    }

    public Resource resolveEntity(String name, String systemId, String publicId) {
        logger.fine("resolveEntity(" + name + "," + systemId + "," + publicId + ")");
        CatalogResult resolved = this.catalog.lookupEntity(name, systemId, publicId);
        if (resolved == null || resolved.expired()) {
            return this.cacheStreamSystem(systemId, publicId);
        }
        return this.streamResult(resolved);
    }

    public Resource resolveNamespaceURI(String uri, String nature, String purpose) {
        logger.fine("resolveNamespaceURI(" + uri + "," + nature + "," + purpose + ")");
        CatalogResult resolved = this.catalog.lookupNamespaceURI(uri, nature, purpose);
        if (resolved != null) {
            return this.streamResult(resolved);
        }
        if (builder == null) {
            return this.streamResult(new CatalogResult(uri, uri));
        }
        Resource nsResult = this.resolveURI(uri, null);
        String rddlURI = null;
        try {
            Document doc = builder.parse(nsResult.uri());
            NodeList rsrcs = doc.getElementsByTagNameNS("http://www.rddl.org/", "resource");
            for (int pos = 0; rddlURI == null && pos < rsrcs.getLength(); ++pos) {
                Element rsrc = (Element)rsrcs.item(pos);
                String rnature = DOMUtils.attr(rsrc, "http://www.w3.org/1999/xlink", "role");
                String rpurpose = DOMUtils.attr(rsrc, "http://www.w3.org/1999/xlink", "arcrole");
                String rhref = DOMUtils.attr(rsrc, "http://www.w3.org/1999/xlink", "href");
                if (rnature == null || !rnature.equals(nature) || rpurpose == null || !rpurpose.equals(purpose) || rhref == null) continue;
                rddlURI = DOMUtils.makeAbsolute(rsrc, rhref, uri);
            }
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (rddlURI == null) {
            return this.streamResult(new CatalogResult(uri, uri));
        }
        return this.cacheStreamNamespaceURI(rddlURI, nature, purpose);
    }

    public Resource resolveDoctype(String name) {
        logger.fine("resolveDoctype(" + name + ")");
        CatalogResult resolved = this.catalog.lookupDoctype(name, null, null);
        if (resolved == null) {
            return null;
        }
        return this.streamResult(resolved);
    }

    private String getScheme(String uri) {
        int pos = uri.indexOf(":");
        if (pos >= 0) {
            return uri.substring(0, pos);
        }
        return null;
    }
}

