/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.IdrefTest;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyManager
implements Serializable {
    private HashMap<StructuredQName, KeyDefinitionSet> keyMap = new HashMap(10);
    private transient WeakHashMap<DocumentInfo, WeakReference<HashMap<Long, Object>>> docIndexes = new WeakHashMap(10);

    public KeyManager(Configuration config) {
        this.registerIdrefKey(config);
    }

    private void registerIdrefKey(Configuration config) {
        IdrefTest idref = IdrefTest.getInstance();
        StringFn sf = (StringFn)SystemFunction.makeSystemFunction("string", new Expression[]{new ContextItemExpression()});
        StringLiteral regex = new StringLiteral("\\s+");
        Tokenize use = (Tokenize)SystemFunction.makeSystemFunction("tokenize", new Expression[]{sf, regex});
        KeyDefinition key = new KeyDefinition(idref, use, null, null);
        key.setIndexedItemType(BuiltInAtomicType.STRING);
        try {
            this.addKeyDefinition(StandardNames.getStructuredQName(562), key, config);
        }
        catch (XPathException err) {
            throw new AssertionError((Object)err);
        }
    }

    public void preRegisterKeyDefinition(StructuredQName keyName) {
        KeyDefinitionSet keySet = this.keyMap.get(keyName);
        if (keySet == null) {
            keySet = new KeyDefinitionSet(keyName, this.keyMap.size());
            this.keyMap.put(keyName, keySet);
        }
    }

    public void addKeyDefinition(StructuredQName keyName, KeyDefinition keydef, Configuration config) throws XPathException {
        KeyDefinitionSet keySet = this.keyMap.get(keyName);
        if (keySet == null) {
            keySet = new KeyDefinitionSet(keyName, this.keyMap.size());
            this.keyMap.put(keyName, keySet);
        }
        keySet.addKeyDefinition(keydef);
        boolean backwardsCompatible = keySet.isBackwardsCompatible();
        if (backwardsCompatible) {
            List<KeyDefinition> v = keySet.getKeyDefinitions();
            for (int i = 0; i < v.size(); ++i) {
                KeyDefinition kd = v.get(i);
                kd.setBackwardsCompatible(true);
                if (kd.getBody().getItemType(config.getTypeHierarchy()).equals(BuiltInAtomicType.STRING)) continue;
                AtomicSequenceConverter exp = new AtomicSequenceConverter(kd.getBody(), BuiltInAtomicType.STRING);
                kd.setBody(exp);
            }
        }
    }

    public KeyDefinitionSet getKeyDefinitionSet(StructuredQName qName) {
        return this.keyMap.get(qName);
    }

    private synchronized HashMap buildIndex(KeyDefinitionSet keySet, BuiltInAtomicType itemType, Set<BuiltInAtomicType> foundItemTypes, DocumentInfo doc, XPathContext context) throws XPathException {
        List<KeyDefinition> definitions = keySet.getKeyDefinitions();
        HashMap<Object, List<NodeInfo>> index = new HashMap<Object, List<NodeInfo>>(100);
        for (int k = 0; k < definitions.size(); ++k) {
            this.constructIndex(doc, index, definitions.get(k), itemType, foundItemTypes, context, k == 0);
        }
        return index;
    }

    private void constructIndex(DocumentInfo doc, HashMap<Object, List<NodeInfo>> index, KeyDefinition keydef, BuiltInAtomicType soughtItemType, Set<BuiltInAtomicType> foundItemTypes, XPathContext context, boolean isFirst) throws XPathException {
        Item item;
        PatternFinder match = keydef.getMatch();
        XPathContextMajor xc = context.newContext();
        xc.setOrigin(keydef);
        SlotManager map = keydef.getStackFrameMap();
        if (map != null) {
            xc.openStackFrame(map);
        }
        SequenceIterator iter = match.selectNodes(doc, xc);
        while ((item = iter.next()) != null) {
            this.processKeyNode((NodeInfo)item, soughtItemType, foundItemTypes, keydef, index, xc, isFirst);
        }
    }

    private void processKeyNode(NodeInfo curr, BuiltInAtomicType soughtItemType, Set<BuiltInAtomicType> foundItemTypes, KeyDefinition keydef, HashMap<Object, List<NodeInfo>> index, XPathContext xc, boolean isFirst) throws XPathException {
        AtomicValue item;
        AxisIterator si = SingleNodeIterator.makeIterator(curr);
        si.next();
        xc.setCurrentIterator(si);
        StringCollator collation = keydef.getCollation();
        ConversionRules rules = xc.getConfiguration().getConversionRules();
        SequenceIterable use = keydef.getUse();
        SequenceIterator useval = use.iterate(xc);
        while ((item = (AtomicValue)useval.next()) != null) {
            Object val;
            BuiltInAtomicType actualItemType = item.getPrimitiveType();
            if (foundItemTypes != null) {
                foundItemTypes.add(actualItemType);
            }
            if (!Type.isComparable(actualItemType, soughtItemType, false)) {
                if (keydef.isStrictComparison()) {
                    XPathException de = new XPathException("Cannot compare " + soughtItemType + " to " + actualItemType + " using 'eq'");
                    de.setErrorCode("XPTY0004");
                    throw de;
                }
                if (keydef.isConvertUntypedToOther() && actualItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    item = item.convert(soughtItemType, true, rules).asAtomic();
                } else if (!keydef.isConvertUntypedToOther() || !soughtItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) continue;
            }
            if (soughtItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || soughtItemType.equals(BuiltInAtomicType.STRING) || soughtItemType.equals(BuiltInAtomicType.ANY_URI)) {
                val = collation == null ? item.getStringValue() : collation.getCollationKey(item.getStringValue());
            } else {
                if (item.isNaN()) break;
                try {
                    AtomicValue av = item.convert(soughtItemType, true, rules).asAtomic();
                    val = av.getXPathComparable(false, collation, xc);
                }
                catch (XPathException err) {
                    break;
                }
            }
            List<NodeInfo> nodes = index.get(val);
            if (nodes == null) {
                nodes = new ArrayList<NodeInfo>(4);
                index.put(val, nodes);
                nodes.add(curr);
                continue;
            }
            if (isFirst) {
                if (nodes.get(nodes.size() - 1) == curr) continue;
                nodes.add(curr);
                continue;
            }
            LocalOrderComparer comparer = LocalOrderComparer.getInstance();
            boolean found = false;
            for (int i = 0; i < nodes.size(); ++i) {
                int d = comparer.compare(curr, nodes.get(i));
                if (d > 0) continue;
                if (d != 0) {
                    nodes.add(i, curr);
                }
                found = true;
                break;
            }
            if (found) continue;
            nodes.add(curr);
        }
    }

    public SequenceIterator selectByKey(StructuredQName keyName, DocumentInfo doc, AtomicValue soughtValue, XPathContext context) throws XPathException {
        KeyDefinitionSet keyDef = this.getKeyDefinitionSet(keyName);
        if (keyDef == null) {
            throw new XPathException("Key " + keyName.getDisplayName() + " has not been defined");
        }
        return this.selectByKey(keyDef, doc, soughtValue, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceIterator selectByKey(KeyDefinitionSet keySet, DocumentInfo doc, AtomicValue soughtValue, XPathContext context) throws XPathException {
        HashMap indexList;
        HashMap index;
        if (soughtValue == null) {
            return EmptyIterator.getInstance();
        }
        List<KeyDefinition> definitions = keySet.getKeyDefinitions();
        KeyDefinition definition = definitions.get(0);
        StringCollator collation = definition.getCollation();
        if (keySet.isBackwardsCompatible()) {
            ConversionRules rules = context.getConfiguration().getConversionRules();
            soughtValue = soughtValue.convert(BuiltInAtomicType.STRING, true, rules).asAtomic();
        } else {
            BuiltInAtomicType itemType = soughtValue.getPrimitiveType();
            if (itemType.equals(BuiltInAtomicType.INTEGER) || itemType.equals(BuiltInAtomicType.DECIMAL) || itemType.equals(BuiltInAtomicType.FLOAT)) {
                soughtValue = new DoubleValue(((NumericValue)soughtValue).getDoubleValue());
            }
        }
        HashSet<BuiltInAtomicType> foundItemTypes = null;
        AtomicValue value = soughtValue;
        if (soughtValue instanceof UntypedAtomicValue && definition.isConvertUntypedToOther()) {
            BuiltInAtomicType useType = definition.getIndexedItemType();
            if (useType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                foundItemTypes = new HashSet<BuiltInAtomicType>(10);
                useType = BuiltInAtomicType.STRING;
            }
            ConversionRules rules = context.getConfiguration().getConversionRules();
            value = soughtValue.convert(useType, true, rules).asAtomic();
        }
        int keySetNumber = keySet.getKeySetNumber();
        BuiltInAtomicType itemType = value.getPrimitiveType();
        DocumentInfo documentInfo = doc;
        synchronized (documentInfo) {
            Object indexObject = this.getIndex(doc, keySetNumber, itemType);
            if (indexObject instanceof String) {
                XPathException de = new XPathException("Key definition is circular");
                de.setXPathContext(context);
                de.setErrorCode("XTDE0640");
                throw de;
            }
            index = (HashMap)indexObject;
            if (index == null) {
                this.putIndex(doc, keySetNumber, itemType, "Under Construction", context);
                index = this.buildIndex(keySet, itemType, foundItemTypes, doc, context);
                this.putIndex(doc, keySetNumber, itemType, index, context);
                if (foundItemTypes != null) {
                    for (BuiltInAtomicType t : foundItemTypes) {
                        if (t.equals(BuiltInAtomicType.STRING)) continue;
                        this.putIndex(doc, keySetNumber, t, "Under Construction", context);
                        index = this.buildIndex(keySet, t, null, doc, context);
                        this.putIndex(doc, keySetNumber, t, index, context);
                    }
                }
            }
        }
        if (foundItemTypes == null) {
            ArrayList nodes = (ArrayList)index.get(KeyManager.getCollationKey(value, itemType, collation, context));
            if (nodes == null) {
                return EmptyIterator.getInstance();
            }
            return new ListIterator(nodes);
        }
        LookaheadIterator result = null;
        WeakReference<HashMap<Long, Object>> ref = this.docIndexes.get(doc);
        if (ref != null && (indexList = (HashMap)ref.get()) != null) {
            Iterator i = indexList.keySet().iterator();
            while (i.hasNext()) {
                ConversionRules rules;
                ArrayList nodes;
                long key = (Long)i.next();
                if (key >> 32 != (long)keySetNumber) continue;
                int typefp = (int)key;
                BuiltInAtomicType type = (BuiltInAtomicType)BuiltInType.getSchemaType(typefp);
                Object indexObject2 = this.getIndex(doc, keySetNumber, type);
                if (indexObject2 instanceof String) {
                    XPathException de = new XPathException("Key definition is circular");
                    de.setXPathContext(context);
                    de.setErrorCode("XTDE0640");
                    throw de;
                }
                HashMap index2 = (HashMap)indexObject2;
                if (index2.isEmpty() || (nodes = (ArrayList)index2.get(KeyManager.getCollationKey(value = soughtValue.convert(type, true, rules = context.getConfiguration().getConversionRules()).asAtomic(), type, collation, context))) == null) continue;
                if (result == null) {
                    result = new ListIterator(nodes);
                    continue;
                }
                result = new UnionEnumeration(result, new ListIterator(nodes), LocalOrderComparer.getInstance());
            }
        }
        if (result == null) {
            return EmptyIterator.getInstance();
        }
        return result;
    }

    private static Object getCollationKey(AtomicValue value, BuiltInAtomicType itemType, StringCollator collation, XPathContext context) throws XPathException {
        Object val = itemType.equals(BuiltInAtomicType.STRING) || itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || itemType.equals(BuiltInAtomicType.ANY_URI) ? (collation == null ? value.getStringValue() : collation.getCollationKey(value.getStringValue())) : value.getXPathComparable(false, collation, context);
        return val;
    }

    private synchronized void putIndex(DocumentInfo doc, int keyFingerprint, AtomicType itemType, Object index, XPathContext context) {
        HashMap indexList;
        WeakReference<HashMap<Long, Object>> indexRef;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((indexRef = this.docIndexes.get(doc)) == null || indexRef.get() == null) {
            indexList = new HashMap(10);
            Controller controller = context.getController();
            if (controller.getDocumentPool().contains(doc)) {
                context.getController().setUserData(doc, "saxon:key-index-list", indexList);
            } else {
                doc.setUserData("saxon:key-index-list", indexList);
            }
            this.docIndexes.put(doc, new WeakReference<HashMap>(indexList));
        } else {
            indexList = (HashMap)indexRef.get();
        }
        indexList.put((long)keyFingerprint << 32 | (long)itemType.getFingerprint(), index);
    }

    private synchronized Object getIndex(DocumentInfo doc, int keyFingerprint, AtomicType itemType) {
        WeakReference<HashMap<Long, Object>> ref;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((ref = this.docIndexes.get(doc)) == null) {
            return null;
        }
        HashMap indexList = (HashMap)ref.get();
        if (indexList == null) {
            return null;
        }
        return indexList.get((long)keyFingerprint << 32 | (long)itemType.getFingerprint());
    }

    public void clearDocumentIndexes(DocumentInfo doc) {
        this.docIndexes.remove(doc);
    }

    public int getNumberOfKeyDefinitions() {
        return this.keyMap.size();
    }

    public void explainKeys(ExpressionPresenter out) {
        if (this.keyMap.size() < 2) {
            return;
        }
        out.startElement("keys");
        for (Map.Entry<StructuredQName, KeyDefinitionSet> e : this.keyMap.entrySet()) {
            StructuredQName qName = e.getKey();
            List<KeyDefinition> list = e.getValue().getKeyDefinitions();
            for (KeyDefinition kd : list) {
                out.startElement("key");
                out.emitAttribute("name", qName.getDisplayName());
                out.emitAttribute("match", kd.getMatch().toString());
                if (kd.getUse() instanceof Expression) {
                    ((Expression)kd.getUse()).explain(out);
                }
                out.endElement();
            }
        }
        out.endElement();
    }
}

