/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;

public class EscapeMarkup
extends DefaultStep {
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public EscapeMarkup(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        Serializer serializer = this.makeSerializer();
        XdmNode xdmNode = this.source.read();
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(xdmNode.getBaseURI());
        for (XdmNode xdmNode2 : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
            if (xdmNode2.getNodeKind() == XdmNodeKind.COMMENT) {
                treeWriter.addComment(xdmNode2.getStringValue());
                continue;
            }
            if (xdmNode2.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
                treeWriter.addPI(xdmNode2.getNodeName().getLocalName(), xdmNode2.getStringValue());
                continue;
            }
            if (xdmNode2.getNodeKind() == XdmNodeKind.TEXT) {
                treeWriter.addText(xdmNode2.getStringValue());
                continue;
            }
            treeWriter.addStartElement(xdmNode2);
            treeWriter.addAttributes(xdmNode2);
            treeWriter.startContent();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            serializer.setOutputStream((OutputStream)byteArrayOutputStream);
            S9apiUtils.serialize(this.runtime, xdmNode2, serializer);
            String string = byteArrayOutputStream.toString();
            string = string.replaceAll("^<.*?>", "");
            string = string.replaceAll("<[^<>]*?>$", "");
            treeWriter.addText(string);
            treeWriter.addEndElement();
        }
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

