/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Version;
import javax.xml.transform.TransformerException;

public class Loader {
    private static boolean tracing = false;

    public static synchronized void setTracing(boolean bl) {
        tracing = bl;
    }

    public static Class getClass(String string) throws TransformerException {
        if (tracing) {
            System.err.println("Loading " + string);
        }
        if (Version.isPreJDK12()) {
            try {
                return Class.forName(string);
            }
            catch (Exception exception) {
                throw new TransformerException("Failed to load " + string, exception);
            }
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    return classLoader.loadClass(string);
                }
                catch (Exception exception) {
                    return Class.forName(string);
                }
            }
            return Class.forName(string);
        }
        catch (Exception exception) {
            throw new TransformerException("Failed to load " + string, exception);
        }
    }

    public static Object getInstance(String string) throws TransformerException {
        Class clazz = Loader.getClass(string);
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new TransformerException("Failed to instantiate class " + string, exception);
        }
    }
}

