# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.7.3.0
#hackport: flags: build-example:examples

CABAL_HACKAGE_REVISION=1

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="Provides some basic WAI handlers and middleware"
HOMEPAGE="https://github.com/yesodweb/wai"

LICENSE="MIT"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="examples"

CABAL_CHDEPS=(
	'executable example' "executable ${PN}-example"
)

RDEPEND="
	dev-haskell/aeson:=[profile?]
	>=dev-haskell/ansi-terminal-0.4:=[profile?]
	dev-haskell/base64-bytestring:=[profile?]
	dev-haskell/call-stack:=[profile?]
	>=dev-haskell/case-insensitive-0.2:=[profile?]
	dev-haskell/cookie:=[profile?]
	dev-haskell/data-default-class:=[profile?]
	>=dev-haskell/fast-logger-2.4.5:=[profile?]
	>=dev-haskell/http-types-0.7:=[profile?]
	dev-haskell/hunit:=[profile?]
	>=dev-haskell/iproute-1.7.8:=[profile?]
	>=dev-haskell/network-2.6.1.0:=[profile?]
	>=dev-haskell/resourcet-0.4.6:=[profile?] <dev-haskell/resourcet-1.4:=[profile?]
	>=dev-haskell/streaming-commons-0.2:=[profile?]
	dev-haskell/vault:=[profile?]
	>=dev-haskell/wai-3.2.2.1:=[profile?] <dev-haskell/wai-3.3:=[profile?]
	>=dev-haskell/wai-logger-2.3.7:=[profile?]
	>=dev-haskell/warp-3.3.22:=[profile?]
	dev-haskell/word8:=[profile?]
	>=dev-lang/ghc-8.6.3:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-2.4.0.1
	test? (
		>=dev-haskell/hspec-1.3
		dev-haskell/temporary
		dev-haskell/zlib
	)
"
BDEPEND="
	test? (
		dev-haskell/hspec-discover
	)
"

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag examples build-example)
}

pkg_postinst() {
	if use examples; then
		elog "The example executable installed with this package (normally named"
		elog "'example') has been renamed to '${PN}-example' to help prevent name"
		elog "collisions."
	fi

	haskell-cabal_pkg_postinst
}
