# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit toolchain-funcs

DESCRIPTION="Switch user and group id and exec"
HOMEPAGE="https://github.com/ncopa/su-exec"
SRC_URI="https://github.com/ncopa/su-exec/archive/v${PV}.tar.gz -> ${P}.tar.gz"

LICENSE="MIT"
SLOT="0"
KEYWORDS="~amd64"
IUSE="static"

src_prepare() {
	default
	sed -i -e "s/-Werror//" Makefile || die
}

src_compile() {
	CC="$(tc-getCC)" emake $(usex static "${PN}-static" "")
}

src_install() {
	newbin ${PN}$(usex static "-static" "") ${PN}
	dodoc README.md
}
