/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.MethodJITClassGenerator;
import org.jruby.compiler.MethodJITTask;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.util.collections.IntHashMap;

class MethodCompiledJITTask
extends JITCompiler.Task {
    private final String className;
    private final CompiledIRMethod method;
    private final String methodName;

    public MethodCompiledJITTask(JITCompiler jitCompiler, CompiledIRMethod method2, String className) {
        super(jitCompiler);
        this.method = method2;
        this.className = className;
        this.methodName = method2.getName();
    }

    @Override
    public void exec() throws NoSuchMethodException, IllegalAccessException {
        block3: {
            Iterator<IntHashMap.Entry<MethodType>> iterator;
            String excludeModuleName = MethodJITTask.checkExcludedMethod(this.jitCompiler.config, this.className, this.methodName, this.method);
            if (excludeModuleName != null) {
                this.method.setCallCount(-1);
                if (this.jitCompiler.config.isJitLogging()) {
                    this.logImpl("skipping (compiled) method in " + excludeModuleName, new Object[0]);
                }
                return;
            }
            IRScope methodScope = this.method.getIRScope();
            String key2 = SexpMaker.sha1(methodScope);
            Ruby runtime2 = this.jitCompiler.runtime;
            JVMVisitor visitor = JVMVisitor.newForJIT(runtime2);
            MethodJITClassGenerator generator = new MethodJITClassGenerator(this.className, this.methodName, key2, runtime2, this.method, visitor);
            JVMVisitorMethodContext context = new JVMVisitorMethodContext();
            generator.compile(context);
            Class<?> sourceClass = this.defineClass(generator, visitor, methodScope, this.method.ensureInstrsReady());
            if (sourceClass == null) {
                return;
            }
            String variableName = context.getVariableName();
            MethodHandle variable = JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, variableName, context.getNativeSignature(-1));
            IntHashMap<MethodType> signatures = context.getNativeSignaturesExceptVariable();
            this.method.setVariable(variable);
            if (signatures.size() == 0 || !(iterator = signatures.entrySet().iterator()).hasNext()) break block3;
            IntHashMap.Entry<MethodType> entry = iterator.next();
            this.method.setSpecific(JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, context.getSpecificName(), entry.getValue()));
        }
    }

    @Override
    protected String getSourceFile() {
        return this.method.getFile();
    }

    @Override
    protected void logJitted() {
        this.logImpl("(compiled) method done jitting", new Object[0]);
    }

    @Override
    protected void logFailed(Throwable ex) {
        this.logImpl("could not re-compile method; passes run: " + this.method.getIRScope().getExecutedPasses(), ex);
    }

    @Override
    protected void logImpl(String message2, Object ... reason2) {
        JITCompiler.log(this.method, this.methodName, message2, reason2);
    }
}

