﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/b2bi/B2BIRequest.h>
#include <aws/b2bi/B2BI_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace B2BI {
namespace Model {

/**
 */
class GetTransformerRequest : public B2BIRequest {
 public:
  AWS_B2BI_API GetTransformerRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetTransformer"; }

  AWS_B2BI_API Aws::String SerializePayload() const override;

  AWS_B2BI_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>Specifies the system-assigned unique identifier for the transformer.</p>
   */
  inline const Aws::String& GetTransformerId() const { return m_transformerId; }
  inline bool TransformerIdHasBeenSet() const { return m_transformerIdHasBeenSet; }
  template <typename TransformerIdT = Aws::String>
  void SetTransformerId(TransformerIdT&& value) {
    m_transformerIdHasBeenSet = true;
    m_transformerId = std::forward<TransformerIdT>(value);
  }
  template <typename TransformerIdT = Aws::String>
  GetTransformerRequest& WithTransformerId(TransformerIdT&& value) {
    SetTransformerId(std::forward<TransformerIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_transformerId;
  bool m_transformerIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace B2BI
}  // namespace Aws
