﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediaconvert/MediaConvert_EXPORTS.h>

namespace Aws {
namespace MediaConvert {
namespace Model {
enum class QueueListBy { NOT_SET, NAME, CREATION_DATE };

namespace QueueListByMapper {
AWS_MEDIACONVERT_API QueueListBy GetQueueListByForName(const Aws::String& name);

AWS_MEDIACONVERT_API Aws::String GetNameForQueueListBy(QueueListBy value);
}  // namespace QueueListByMapper
}  // namespace Model
}  // namespace MediaConvert
}  // namespace Aws
