/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.mpxj.DataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.GenericCriteria;
import net.sf.mpxj.GenericCriteriaPrompt;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TestOperator;
import net.sf.mpxj.mpp.MPPUtility;

public abstract class CriteriaReader {
    private ProjectProperties m_properties;
    private byte[] m_criteriaData;
    private boolean[] m_criteriaType;
    private int m_criteriaTextStart;
    private int m_dataOffset;
    private List<GenericCriteriaPrompt> m_prompts;
    private List<FieldType> m_fields;
    protected final Map<Integer, byte[]> m_criteriaBlockMap = new TreeMap<Integer, byte[]>();

    protected abstract int getCriteriaStartOffset();

    protected abstract int getCriteriaBlockSize();

    protected abstract byte[] getChildBlock(byte[] var1);

    protected abstract byte[] getListNextBlock(byte[] var1);

    protected abstract int getTextOffset(byte[] var1);

    protected abstract int getPromptOffset(byte[] var1);

    protected abstract int getValueOffset();

    protected abstract int getTimeUnitsOffset();

    protected abstract int getCriteriaTextStartOffset();

    protected abstract FieldType getFieldType(byte[] var1);

    public GenericCriteria process(ProjectProperties properties, byte[] data, int dataOffset, int entryOffset, List<GenericCriteriaPrompt> prompts, List<FieldType> fields, boolean[] criteriaType) {
        this.m_properties = properties;
        this.m_prompts = prompts;
        this.m_fields = fields;
        this.m_criteriaType = criteriaType;
        this.m_dataOffset = dataOffset;
        if (this.m_criteriaType != null) {
            this.m_criteriaType[0] = true;
            this.m_criteriaType[1] = true;
        }
        this.m_criteriaBlockMap.clear();
        this.m_criteriaData = data;
        this.m_criteriaTextStart = MPPUtility.getShort(this.m_criteriaData, this.m_dataOffset + this.getCriteriaTextStartOffset());
        int criteriaStartOffset = this.getCriteriaStartOffset();
        int criteriaBlockSize = this.getCriteriaBlockSize();
        if (this.m_criteriaData.length <= this.m_criteriaTextStart) {
            return null;
        }
        while (criteriaStartOffset + criteriaBlockSize <= this.m_criteriaTextStart) {
            byte[] block = new byte[criteriaBlockSize];
            System.arraycopy(this.m_criteriaData, this.m_dataOffset + criteriaStartOffset, block, 0, criteriaBlockSize);
            this.m_criteriaBlockMap.put(criteriaStartOffset, block);
            criteriaStartOffset += criteriaBlockSize;
        }
        if (entryOffset == -1) {
            entryOffset = this.getCriteriaStartOffset();
        }
        ArrayList<GenericCriteria> list = new ArrayList<GenericCriteria>();
        this.processBlock(list, this.m_criteriaBlockMap.get(entryOffset));
        GenericCriteria criteria = list.isEmpty() ? null : (GenericCriteria)list.get(0);
        return criteria;
    }

    private void processBlock(List<GenericCriteria> list, byte[] block) {
        if (block != null) {
            if (MPPUtility.getShort(block, 0) > 998) {
                this.addCriteria(list, block);
            } else {
                switch (block[0]) {
                    case 11: {
                        this.processBlock(list, this.getChildBlock(block));
                        break;
                    }
                    case 6: {
                        this.processBlock(list, this.getListNextBlock(block));
                        break;
                    }
                    case -19: {
                        this.addCriteria(list, block);
                        break;
                    }
                    case 25: 
                    case 27: {
                        this.addBlock(list, block, TestOperator.AND);
                        break;
                    }
                    case 26: 
                    case 28: {
                        this.addBlock(list, block, TestOperator.OR);
                    }
                }
            }
        }
    }

    private void addCriteria(List<GenericCriteria> list, byte[] block) {
        byte[] leftBlock = this.getChildBlock(block);
        byte[] rightBlock1 = this.getListNextBlock(leftBlock);
        byte[] rightBlock2 = this.getListNextBlock(rightBlock1);
        TestOperator operator2 = TestOperator.getInstance(MPPUtility.getShort(block, 0) - 999);
        FieldType leftValue = this.getFieldType(leftBlock);
        Object rightValue1 = this.getValue(leftValue, rightBlock1);
        Object rightValue2 = rightBlock2 == null ? null : this.getValue(leftValue, rightBlock2);
        GenericCriteria criteria = new GenericCriteria(this.m_properties);
        criteria.setLeftValue(leftValue);
        criteria.setOperator(operator2);
        criteria.setRightValue(0, rightValue1);
        criteria.setRightValue(1, rightValue2);
        list.add(criteria);
        if (this.m_criteriaType != null) {
            this.m_criteriaType[0] = leftValue.getFieldTypeClass() == FieldTypeClass.TASK;
            boolean bl = this.m_criteriaType[1] = !this.m_criteriaType[0];
        }
        if (this.m_fields != null) {
            this.m_fields.add(leftValue);
        }
        this.processBlock(list, this.getListNextBlock(block));
    }

    private void addBlock(List<GenericCriteria> list, byte[] block, TestOperator operator2) {
        GenericCriteria result = new GenericCriteria(this.m_properties);
        result.setOperator(operator2);
        list.add(result);
        this.processBlock(result.getCriteriaList(), this.getChildBlock(block));
        this.processBlock(list, this.getListNextBlock(block));
    }

    private Object getValue(FieldType field, byte[] block) {
        Object result = null;
        switch (block[0]) {
            case 7: {
                result = this.getFieldType(block);
                break;
            }
            case 1: {
                result = this.getConstantValue(field, block);
                break;
            }
            case 0: {
                result = this.getPromptValue(field, block);
            }
        }
        return result;
    }

    private Object getConstantValue(FieldType type, byte[] block) {
        Object value;
        DataType dataType = type.getDataType();
        if (dataType == null) {
            value = null;
        } else {
            switch (dataType) {
                case DURATION: {
                    value = MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(block, this.getValueOffset()), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(block, this.getTimeUnitsOffset())));
                    break;
                }
                case NUMERIC: {
                    value = MPPUtility.getDouble(block, this.getValueOffset());
                    break;
                }
                case PERCENTAGE: {
                    value = (double)MPPUtility.getShort(block, this.getValueOffset());
                    break;
                }
                case CURRENCY: {
                    value = MPPUtility.getDouble(block, this.getValueOffset()) / 100.0;
                    break;
                }
                case STRING: {
                    int textOffset = this.getTextOffset(block);
                    value = MPPUtility.getUnicodeString(this.m_criteriaData, this.m_dataOffset + this.m_criteriaTextStart + textOffset);
                    break;
                }
                case BOOLEAN: {
                    int intValue = MPPUtility.getShort(block, this.getValueOffset());
                    value = intValue == 1 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case DATE: {
                    value = MPPUtility.getTimestamp(block, this.getValueOffset());
                    break;
                }
                default: {
                    value = null;
                }
            }
        }
        return value;
    }

    private GenericCriteriaPrompt getPromptValue(FieldType field, byte[] block) {
        int textOffset = this.getPromptOffset(block);
        String value = MPPUtility.getUnicodeString(this.m_criteriaData, this.m_criteriaTextStart + textOffset);
        GenericCriteriaPrompt prompt = new GenericCriteriaPrompt(field.getDataType(), value);
        if (this.m_prompts != null) {
            this.m_prompts.add(prompt);
        }
        return prompt;
    }
}

