/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator.console;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.equinox.internal.simpleconfigurator.console.ApplyCommand;
import org.eclipse.equinox.internal.simpleconfigurator.utils.Utils;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;

public class ConfiguratorCommandProvider
implements CommandProvider {
    public static final String NEW_LINE = "\r\n";
    private final BundleContext context;

    public ConfiguratorCommandProvider(BundleContext context) {
        this.context = context;
    }

    private URL toURL(CommandInterpreter interpreter, String urlString) {
        try {
            return Utils.buildURL(urlString);
        }
        catch (MalformedURLException e) {
            interpreter.println((Object)e.getMessage());
            return null;
        }
    }

    public void _confapply(CommandInterpreter interpreter) {
        String parameter = interpreter.nextArgument();
        URL configURL = null;
        if (parameter != null) {
            configURL = this.toURL(interpreter, parameter);
        }
        new ApplyCommand(interpreter, this.context, configURL).run();
    }

    public Object _help(CommandInterpreter intp) {
        String commandName = intp.nextArgument();
        if (commandName == null) {
            return Boolean.FALSE;
        }
        String help = this.getHelp(commandName);
        if (help.length() > 0) {
            return help;
        }
        return Boolean.FALSE;
    }

    public String getHelp() {
        return this.getHelp(null);
    }

    private String getHelp(String commandName) {
        StringBuilder help = new StringBuilder();
        if (commandName == null) {
            help.append("---");
            help.append("Configurator Commands");
            help.append("---");
            help.append(NEW_LINE);
        }
        if (commandName == null || "confapply".equals(commandName)) {
            help.append("\tconfapply [<config URL>] - Applies a configuration");
            help.append(NEW_LINE);
        }
        return help.toString();
    }
}

