/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.JAutoCheckBoxMenuItem;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.view.swing.map.outline.OutlineActionTarget;
import org.freeplane.view.swing.map.outline.OutlineActionTargetProvider;
import org.freeplane.view.swing.map.outline.OutlineGeometry;

class OutlineActions {
    private final OutlineActionTargetProvider provider;
    final Action navigateUp = new AbstractAction("Navigate Up"){

        @Override
        public void actionPerformed(ActionEvent e) {
            OutlineActions.this.controller().navigateUp();
        }
    };
    final Action navigateDown = new AbstractAction("Navigate Down"){

        @Override
        public void actionPerformed(ActionEvent e) {
            OutlineActions.this.controller().navigateDown();
        }
    };
    final Action navigatePageUp = new AbstractAction("Page Up"){

        @Override
        public void actionPerformed(ActionEvent e) {
            OutlineActions.this.controller().navigatePageUp();
        }
    };
    final Action navigatePageDown = new AbstractAction("Page Down"){

        @Override
        public void actionPerformed(ActionEvent e) {
            OutlineActions.this.controller().navigatePageDown();
        }
    };
    final Action goLeft = new AbstractAction("Go left"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OutlineActions.this.isRightToLeft()) {
                OutlineActions.this.controller().expandOrGoToChild();
            } else {
                OutlineActions.this.controller().collapseOrGoToParent();
            }
        }
    };
    final Action goRight = new AbstractAction("Go right"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OutlineActions.this.isRightToLeft()) {
                OutlineActions.this.controller().collapseOrGoToParent();
            } else {
                OutlineActions.this.controller().expandOrGoToChild();
            }
        }
    };
    final Action expandLeft = new AbstractAction("Expand left"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OutlineActions.this.isRightToLeft()) {
                OutlineActions.this.controller().expandSelectedMore();
            } else {
                OutlineActions.this.controller().reduceSelectedExpansion();
            }
        }
    };
    final Action expandRight = new AbstractAction("Expand right"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OutlineActions.this.isRightToLeft()) {
                OutlineActions.this.controller().reduceSelectedExpansion();
            } else {
                OutlineActions.this.controller().expandSelectedMore();
            }
        }
    };
    final Action toggleExpand = new AbstractAction("Toggle Expand/Collapse"){

        @Override
        public void actionPerformed(ActionEvent e) {
            OutlineActions.this.controller().toggleExpandSelected();
        }
    };
    final Action selectInMap = new AbstractAction("Select in Map"){

        @Override
        public void actionPerformed(ActionEvent e) {
            OutlineActions.this.controller().selectSelectedInMap();
        }
    };
    final Action openPreferences = new AbstractAction("Preferences"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Controller controller = Controller.getCurrentController();
            MModeController modeController = (MModeController)controller.getModeController("MindMap");
            modeController.showPreferences("Appearance", "outline_panel");
        }
    };

    private OutlineActionTarget controller() {
        return this.provider.getController();
    }

    private boolean isRightToLeft() {
        return OutlineGeometry.getInstance().isRightToLeft();
    }

    OutlineActions(OutlineActionTargetProvider provider) {
        this.provider = provider;
        this.navigateUp.putValue("AcceleratorKey", KeyStroke.getKeyStroke("UP"));
        this.navigateDown.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DOWN"));
        this.navigatePageUp.putValue("AcceleratorKey", KeyStroke.getKeyStroke("PAGE_UP"));
        this.navigatePageDown.putValue("AcceleratorKey", KeyStroke.getKeyStroke("PAGE_DOWN"));
        this.goLeft.putValue("AcceleratorKey", KeyStroke.getKeyStroke("LEFT"));
        this.goRight.putValue("AcceleratorKey", KeyStroke.getKeyStroke("RIGHT"));
        this.expandLeft.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control LEFT"));
        this.expandRight.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control RIGHT"));
        this.toggleExpand.putValue("AcceleratorKey", KeyStroke.getKeyStroke("SPACE"));
        this.selectInMap.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ENTER"));
    }

    void installOn(JComponent component, int condition) {
        InputMap inputMap = component.getInputMap(condition);
        ActionMap actionMap = component.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("UP"), "navigateUp");
        actionMap.put("navigateUp", this.navigateUp);
        inputMap.put(KeyStroke.getKeyStroke("DOWN"), "navigateDown");
        actionMap.put("navigateDown", this.navigateDown);
        inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), "navigatePageUp");
        actionMap.put("navigatePageUp", this.navigatePageUp);
        inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "navigatePageDown");
        actionMap.put("navigatePageDown", this.navigatePageDown);
        inputMap.put(KeyStroke.getKeyStroke("LEFT"), "goParent");
        actionMap.put("goParent", this.goLeft);
        inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "goChild");
        actionMap.put("goChild", this.goRight);
        inputMap.put(KeyStroke.getKeyStroke("control LEFT"), "reduceExpansion");
        actionMap.put("reduceExpansion", this.expandLeft);
        inputMap.put(KeyStroke.getKeyStroke("control RIGHT"), "expandMore");
        actionMap.put("expandMore", this.expandRight);
    }

    JPopupMenu buildMenuLocalized() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(TranslatedElementFactory.createMenuItem(this.selectInMap, "outline.select.in.map"));
        menu.addSeparator();
        menu.add(TranslatedElementFactory.createMenuItem(this.navigateUp, "outline.navigate.up"));
        menu.add(TranslatedElementFactory.createMenuItem(this.navigateDown, "outline.navigate.down"));
        menu.add(TranslatedElementFactory.createMenuItem(this.navigatePageUp, "outline.page.up"));
        menu.add(TranslatedElementFactory.createMenuItem(this.navigatePageDown, "outline.page.down"));
        menu.addSeparator();
        menu.add(TranslatedElementFactory.createMenuItem(this.goLeft, "outline.go.parent"));
        menu.add(TranslatedElementFactory.createMenuItem(this.goRight, "outline.go.child"));
        menu.addSeparator();
        menu.add(TranslatedElementFactory.createMenuItem(this.expandRight, "outline.expand.more"));
        menu.add(TranslatedElementFactory.createMenuItem(this.expandLeft, "outline.reduce.expansion"));
        menu.add(TranslatedElementFactory.createMenuItem(this.toggleExpand, "outline.toggle.expand"));
        menu.addSeparator();
        menu.add(TranslatedElementFactory.createMenuItem(this.openPreferences, "preferences"));
        AFreeplaneAction toggleOutlineAction = Controller.getCurrentController().getAction("ToggleOutlineAction");
        menu.add(new JAutoCheckBoxMenuItem(toggleOutlineAction));
        return menu;
    }
}

