/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.device;

import org.jboss.logging.Logger;
import org.keycloak.cache.LocalCache;
import org.keycloak.device.DeviceActivityManager;
import org.keycloak.device.DeviceRepresentationProvider;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.account.DeviceRepresentation;
import ua_parser.Client;

public class DeviceRepresentationProviderImpl
implements DeviceRepresentationProvider {
    private static final Logger logger = Logger.getLogger(DeviceActivityManager.class);
    private static final int USER_AGENT_MAX_LENGTH = 512;
    private final LocalCache<String, Client> cache;
    private final KeycloakSession session;

    DeviceRepresentationProviderImpl(KeycloakSession session, LocalCache<String, Client> cache) {
        this.session = session;
        this.cache = cache;
    }

    public DeviceRepresentation deviceRepresentation() {
        KeycloakContext context = this.session.getContext();
        if (context.getRequestHeaders() == null) {
            return null;
        }
        String userAgent = context.getRequestHeaders().getHeaderString("User-Agent");
        if (userAgent == null) {
            return null;
        }
        if (userAgent.length() > 512) {
            logger.warn((Object)"Ignoring User-Agent header. Length is above the permitted: 512");
            return null;
        }
        try {
            Client client = (Client)this.cache.get((Object)userAgent);
            assert (client != null);
            DeviceRepresentation current = new DeviceRepresentation();
            current.setDevice(client.device.family);
            Object browserVersion = client.userAgent.major;
            if (client.userAgent.minor != null) {
                browserVersion = (String)browserVersion + "." + client.userAgent.minor;
            }
            if (client.userAgent.patch != null) {
                browserVersion = (String)browserVersion + "." + client.userAgent.patch;
            }
            if (browserVersion == null) {
                browserVersion = "Unknown";
            }
            current.setBrowser(client.userAgent.family, (String)browserVersion);
            current.setOs(client.os.family);
            Object osVersion = client.os.major;
            if (client.os.minor != null) {
                osVersion = (String)osVersion + "." + client.os.minor;
            }
            if (client.os.patch != null) {
                osVersion = (String)osVersion + "." + client.os.patch;
            }
            if (client.os.patchMinor != null) {
                osVersion = (String)osVersion + "." + client.os.patchMinor;
            }
            current.setOsVersion((String)osVersion);
            current.setIpAddress(context.getConnection().getRemoteHost());
            current.setMobile(userAgent.toLowerCase().contains("mobile"));
            return current;
        }
        catch (Exception cause) {
            logger.error((Object)"Failed to create device info from user agent header", (Throwable)cause);
            return null;
        }
    }
}

