/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.CteGenerateSeriesFunction;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonTableFunction;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmJsonTableFunction;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.sql.ast.tree.expression.JsonTableColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableColumnsClause;
import org.hibernate.sql.ast.tree.expression.JsonTableErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonTableExistsColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableNestedColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableOrdinalityColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableQueryColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonTableValueColumnDefinition;
import org.hibernate.sql.ast.tree.expression.JsonValueEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonValueErrorBehavior;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.QueryTransformer;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2JsonTableFunction
extends JsonTableFunction {
    private final int maximumSeriesSize;

    public DB2JsonTableFunction(int maximumSeriesSize, TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
        this.maximumSeriesSize = maximumSeriesSize;
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> sqmArguments, QueryEngine queryEngine) {
        return new SqmJsonTableFunction<T>(this, this, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), (SqmExpression)sqmArguments.get(0), sqmArguments.size() > 1 ? (SqmExpression)sqmArguments.get(1) : null){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                Literal literal;
                boolean isArray;
                FunctionTableGroup tableGroup = (FunctionTableGroup)super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
                JsonTableFunction.JsonTableArguments arguments = JsonTableFunction.JsonTableArguments.extract(tableGroup.getPrimaryTableReference().getFunctionExpression().getArguments());
                Expression jsonPath = arguments.jsonPath();
                boolean bl = isArray = !(jsonPath instanceof Literal) || DB2JsonTableFunction.this.isArrayAccess((String)(literal = (Literal)jsonPath).getLiteralValue());
                if (isArray || DB2JsonTableFunction.this.hasNestedArray(arguments.columnsClause())) {
                    walker.registerQueryTransformer(new SeriesQueryTransformer(DB2JsonTableFunction.this.maximumSeriesSize));
                }
                return tableGroup;
            }
        };
    }

    @Override
    protected void renderJsonTable(SqlAppender sqlAppender, JsonTableFunction.JsonTableArguments arguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        if (arguments.errorBehavior() == JsonTableErrorBehavior.NULL) {
            throw new QueryException("Can't emulate null on error clause on DB2");
        }
        Expression jsonDocument = arguments.jsonDocument();
        Expression jsonPath = arguments.jsonPath();
        boolean isArray = this.isArrayAccess(jsonPath, walker);
        sqlAppender.appendSql("lateral(select");
        this.renderColumnSelects(sqlAppender, arguments.columnsClause(), 0, isArray);
        sqlAppender.appendSql(" from ");
        if (isArray) {
            sqlAppender.appendSql("max_series");
            sqlAppender.appendSql(" i join ");
        }
        sqlAppender.appendSql("json_table(");
        if (isArray) {
            sqlAppender.appendSql("'{\"a\":'||");
        }
        DB2JsonTableFunction.appendJsonDocument(sqlAppender, jsonPath, jsonDocument, arguments.passingClause(), isArray, walker);
        if (isArray) {
            sqlAppender.appendSql("||'}'");
        }
        sqlAppender.appendSql(",'strict $'");
        this.renderColumns(sqlAppender, arguments.columnsClause(), 0, isArray ? "$.a" : null, walker);
        sqlAppender.appendSql(" error on error) t0");
        if (isArray) {
            sqlAppender.appendSql(" on json_exists('{\"a\":'||");
            if (jsonPath != null) {
                String jsonPathString = arguments.passingClause() != null ? JsonPathHelper.inlinedJsonPathIncludingPassingClause(jsonPath, arguments.passingClause(), walker) : (String)walker.getLiteralValue(jsonPath);
                if (jsonPathString.endsWith("[*]")) {
                    jsonDocument.accept(walker);
                    sqlAppender.appendSql("||'}',");
                    String adaptedJsonPath = jsonPathString.substring(0, jsonPathString.length() - 3);
                    sqlAppender.appendSingleQuoteEscapedString(adaptedJsonPath.replace("$", "$.a"));
                    sqlAppender.appendSql("||'['||(i.i-1)||']')");
                } else {
                    sqlAppender.appendSql("json_query('{\"a\":'||");
                    jsonDocument.accept(walker);
                    sqlAppender.appendSql("||'}',");
                    sqlAppender.appendSingleQuoteEscapedString(jsonPathString.replace("$", "$.a"));
                    sqlAppender.appendSql(" with wrapper)||'}','$.a['||(i.i-1)||']')");
                }
            } else {
                jsonDocument.accept(walker);
                sqlAppender.appendSql("||'}','$.a['||(i.i-1)||']')");
            }
        }
        this.renderNestedColumnJoins(sqlAppender, arguments.columnsClause(), 0, walker);
        sqlAppender.appendSql(')');
    }

    private static void appendJsonDocument(SqlAppender sqlAppender, Expression jsonPath, Expression jsonDocument, JsonPathPassingClause passingClause, boolean isArray, SqlAstTranslator<?> walker) {
        if (jsonPath != null) {
            sqlAppender.appendSql("json_query(");
            if (isArray) {
                String jsonPathString = passingClause != null ? JsonPathHelper.inlinedJsonPathIncludingPassingClause(jsonPath, passingClause, walker) : (String)walker.getLiteralValue(jsonPath);
                if (jsonPathString.endsWith("[*]")) {
                    sqlAppender.appendSql("'{\"a\":'||");
                    jsonDocument.accept(walker);
                    sqlAppender.appendSql("||'}',");
                    String adaptedJsonPath = jsonPathString.substring(0, jsonPathString.length() - 3);
                    sqlAppender.appendSingleQuoteEscapedString(adaptedJsonPath.replace("$", "$.a"));
                    sqlAppender.appendSql("||'['||(i.i-1)||']'");
                } else {
                    sqlAppender.appendSql("'{\"a\":'||");
                    sqlAppender.appendSql("json_query('{\"a\":'||");
                    jsonDocument.accept(walker);
                    sqlAppender.appendSql("||'}',");
                    sqlAppender.appendSingleQuoteEscapedString(jsonPathString.replace("$", "$.a"));
                    sqlAppender.appendSql(" with wrapper)||'}','$.a['||(i.i-1)||']'");
                }
            } else {
                jsonDocument.accept(walker);
                sqlAppender.appendSql(',');
                if (passingClause != null) {
                    JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "", jsonPath, passingClause, walker);
                } else {
                    jsonPath.accept(walker);
                }
            }
            sqlAppender.appendSql(')');
        } else {
            if (isArray) {
                sqlAppender.appendSql("json_query('{\"a\":'||");
            }
            jsonDocument.accept(walker);
            if (isArray) {
                sqlAppender.appendSql("||'}','$.a['||(i.i-1)||']')");
            }
        }
    }

    private boolean isArrayAccess(@Nullable Expression jsonPath, SqlAstTranslator<?> walker) {
        if (jsonPath != null) {
            try {
                return this.isArrayAccess((String)walker.getLiteralValue(jsonPath));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isArrayAccess(String jsonPath) {
        return jsonPath.endsWith("[*]");
    }

    private boolean hasNestedArray(JsonTableColumnsClause jsonTableColumnsClause) {
        for (JsonTableColumnDefinition columnDefinition : jsonTableColumnsClause.getColumnDefinitions()) {
            JsonTableNestedColumnDefinition nestedColumnDefinition;
            if (!(columnDefinition instanceof JsonTableNestedColumnDefinition) || !this.isArrayAccess((nestedColumnDefinition = (JsonTableNestedColumnDefinition)columnDefinition).jsonPath()) && !this.hasNestedArray(nestedColumnDefinition.columns())) continue;
            return true;
        }
        return false;
    }

    private int renderNestedColumnJoins(SqlAppender sqlAppender, JsonTableColumnsClause jsonTableColumnsClause, int clauseLevel, SqlAstTranslator<?> walker) {
        int currentClauseLevel = clauseLevel;
        for (JsonTableColumnDefinition columnDefinition : jsonTableColumnsClause.getColumnDefinitions()) {
            if (!(columnDefinition instanceof JsonTableNestedColumnDefinition)) continue;
            JsonTableNestedColumnDefinition nestedColumnDefinition = (JsonTableNestedColumnDefinition)columnDefinition;
            int nextClauseLevel = currentClauseLevel + 1;
            boolean isArray = this.isArrayAccess(nestedColumnDefinition.jsonPath());
            sqlAppender.appendSql(" left join lateral (select");
            this.renderColumnSelects(sqlAppender, nestedColumnDefinition.columns(), nextClauseLevel, isArray);
            sqlAppender.appendSql(" from ");
            if (isArray) {
                sqlAppender.appendSql("max_series");
                sqlAppender.appendSql(" i join json_table('{\"a\":'||json_query('{\"a\":'||t");
                sqlAppender.appendSql(clauseLevel);
                sqlAppender.appendSql(".nested_");
                sqlAppender.appendSql(nextClauseLevel);
                sqlAppender.appendSql("_||'}','$.a['||(i.i-1)||']')||'}','strict $'");
                this.renderColumns(sqlAppender, nestedColumnDefinition.columns(), nextClauseLevel, "$.a", walker);
                sqlAppender.appendSql(" error on error) t");
                sqlAppender.appendSql(nextClauseLevel);
                sqlAppender.appendSql(" on json_exists('{\"a\":'||t");
                sqlAppender.appendSql(clauseLevel);
                sqlAppender.appendSql(".nested_");
                sqlAppender.appendSql(nextClauseLevel);
                sqlAppender.appendSql("_||'}','$.a['||(i.i-1)||']')");
            } else {
                sqlAppender.appendSql("json_table(t");
                sqlAppender.appendSql(clauseLevel);
                sqlAppender.appendSql(".nested_");
                sqlAppender.appendSql(nextClauseLevel);
                sqlAppender.appendSql("_,'strict $'");
                this.renderColumns(sqlAppender, nestedColumnDefinition.columns(), nextClauseLevel, null, walker);
                sqlAppender.appendSql(" error on error) t");
                sqlAppender.appendSql(nextClauseLevel);
            }
            sqlAppender.appendSql(") t");
            sqlAppender.appendSql(nextClauseLevel);
            sqlAppender.appendSql(" on 1=1");
            currentClauseLevel = this.renderNestedColumnJoins(sqlAppender, nestedColumnDefinition.columns(), nextClauseLevel, walker);
        }
        return currentClauseLevel;
    }

    private void renderColumnSelects(SqlAppender sqlAppender, JsonTableColumnsClause jsonTableColumnsClause, int clauseLevel, boolean isArray) {
        int currentClauseLevel = clauseLevel;
        int separator = 32;
        for (JsonTableColumnDefinition columnDefinition : jsonTableColumnsClause.getColumnDefinitions()) {
            sqlAppender.appendSql((char)separator);
            if (columnDefinition instanceof JsonTableExistsColumnDefinition) {
                JsonTableExistsColumnDefinition existsColumnDefinition = (JsonTableExistsColumnDefinition)columnDefinition;
                sqlAppender.appendSql("json_exists(t");
                sqlAppender.appendSql(clauseLevel);
                sqlAppender.appendSql(".");
                sqlAppender.appendSql(existsColumnDefinition.name());
                sqlAppender.appendSql(',');
                Object jsonPath = existsColumnDefinition.jsonPath() == null ? "$." + existsColumnDefinition.name() : existsColumnDefinition.jsonPath();
                sqlAppender.appendSingleQuoteEscapedString((String)jsonPath);
                JsonExistsErrorBehavior errorBehavior = existsColumnDefinition.errorBehavior();
                if (errorBehavior != null && errorBehavior != JsonExistsErrorBehavior.FALSE) {
                    if (errorBehavior == JsonExistsErrorBehavior.TRUE) {
                        sqlAppender.appendSql(" true on error");
                    } else {
                        sqlAppender.appendSql(" error on error");
                    }
                }
                sqlAppender.appendSql(") ");
                sqlAppender.appendSql(existsColumnDefinition.name());
            } else if (columnDefinition instanceof JsonTableOrdinalityColumnDefinition) {
                JsonTableOrdinalityColumnDefinition ordinalityColumnDefinition = (JsonTableOrdinalityColumnDefinition)columnDefinition;
                if (isArray) {
                    sqlAppender.appendSql("i.i ");
                } else {
                    sqlAppender.appendSql("1 ");
                }
                sqlAppender.appendSql(ordinalityColumnDefinition.name());
            } else if (columnDefinition instanceof JsonTableNestedColumnDefinition) {
                JsonTableNestedColumnDefinition nestedColumnDefinition = (JsonTableNestedColumnDefinition)columnDefinition;
                sqlAppender.appendSql('t');
                sqlAppender.appendSql(currentClauseLevel + 1);
                sqlAppender.appendSql(".*");
                currentClauseLevel += 1 + this.countNestedColumnDefinitions(nestedColumnDefinition.columns());
            } else if (columnDefinition instanceof JsonTableValueColumnDefinition) {
                JsonTableValueColumnDefinition valueColumnDefinition = (JsonTableValueColumnDefinition)columnDefinition;
                sqlAppender.appendSql('t');
                sqlAppender.appendSql(clauseLevel);
                sqlAppender.appendSql('.');
                sqlAppender.appendSql(valueColumnDefinition.name());
            } else {
                JsonTableQueryColumnDefinition queryColumnDefinition = (JsonTableQueryColumnDefinition)columnDefinition;
                sqlAppender.appendSql('t');
                sqlAppender.appendSql(clauseLevel);
                sqlAppender.appendSql('.');
                sqlAppender.appendSql(queryColumnDefinition.name());
            }
            separator = 44;
        }
    }

    private int renderColumns(SqlAppender sqlAppender, JsonTableColumnsClause jsonTableColumnsClause, int clauseLevel, @Nullable String jsonPathPrefix, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(" columns");
        int nextClauseLevel = clauseLevel + 1;
        int separator = 40;
        for (JsonTableColumnDefinition columnDefinition : jsonTableColumnsClause.getColumnDefinitions()) {
            sqlAppender.appendSql((char)separator);
            if (columnDefinition instanceof JsonTableExistsColumnDefinition) {
                JsonTableExistsColumnDefinition definition = (JsonTableExistsColumnDefinition)columnDefinition;
                this.renderJsonExistsColumnDefinition(sqlAppender, definition);
            } else if (columnDefinition instanceof JsonTableQueryColumnDefinition) {
                JsonTableQueryColumnDefinition definition = (JsonTableQueryColumnDefinition)columnDefinition;
                this.renderJsonQueryColumnDefinition(sqlAppender, definition, jsonPathPrefix, walker);
            } else if (columnDefinition instanceof JsonTableValueColumnDefinition) {
                JsonTableValueColumnDefinition definition = (JsonTableValueColumnDefinition)columnDefinition;
                this.renderJsonValueColumnDefinition(sqlAppender, definition, jsonPathPrefix, walker);
            } else if (columnDefinition instanceof JsonTableOrdinalityColumnDefinition) {
                JsonTableOrdinalityColumnDefinition definition = (JsonTableOrdinalityColumnDefinition)columnDefinition;
                this.renderJsonOrdinalityColumnDefinition(sqlAppender, definition);
            } else {
                nextClauseLevel = this.renderJsonNestedColumnDefinition(sqlAppender, (JsonTableNestedColumnDefinition)columnDefinition, nextClauseLevel);
            }
            separator = 44;
        }
        sqlAppender.appendSql(')');
        return nextClauseLevel;
    }

    private void renderColumnPath(String name, @Nullable String jsonPath, @Nullable String jsonPathPrefix, SqlAppender sqlAppender, SqlAstTranslator<?> walker) {
        if (jsonPath != null) {
            super.renderColumnPath(name, (String)(jsonPathPrefix != null ? jsonPathPrefix + jsonPath.substring(1) : jsonPath), sqlAppender, walker);
        } else {
            sqlAppender.appendSql(" path '");
            if (jsonPathPrefix == null) {
                sqlAppender.appendSql('$');
            } else {
                sqlAppender.appendSql(jsonPathPrefix);
            }
            sqlAppender.appendSql('.');
            sqlAppender.appendSql(name);
            sqlAppender.appendSql('\'');
        }
    }

    @Override
    protected String determineColumnType(CastTarget castTarget, SqlAstTranslator<?> walker) {
        String columnType;
        switch (columnType = super.determineColumnType(castTarget, walker)) {
            case "boolean": {
                return "smallint";
            }
        }
        return columnType;
    }

    private void renderJsonQueryColumnDefinition(SqlAppender sqlAppender, JsonTableQueryColumnDefinition definition, @Nullable String jsonPathPrefix, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(this.determineColumnType(new CastTarget(definition.type()), walker));
        if (definition.type().getJdbcType().getDdlTypeCode() != 3001) {
            sqlAppender.appendSql(" format json");
        }
        if (definition.wrapMode() != null) {
            switch (definition.wrapMode()) {
                case WITH_WRAPPER: {
                    sqlAppender.appendSql(" with wrapper");
                    break;
                }
                case WITHOUT_WRAPPER: {
                    sqlAppender.appendSql(" without wrapper");
                    break;
                }
                case WITH_CONDITIONAL_WRAPPER: {
                    sqlAppender.appendSql(" with conditional wrapper");
                }
            }
        }
        this.renderColumnPath(definition.name(), definition.jsonPath(), jsonPathPrefix, sqlAppender, walker);
        if (definition.errorBehavior() != null) {
            switch (definition.errorBehavior()) {
                case ERROR: {
                    sqlAppender.appendSql(" error on error");
                    break;
                }
                case NULL: {
                    sqlAppender.appendSql(" null on error");
                    break;
                }
                case EMPTY_OBJECT: {
                    sqlAppender.appendSql(" empty object on error");
                    break;
                }
                case EMPTY_ARRAY: {
                    sqlAppender.appendSql(" empty array on error");
                }
            }
        }
        if (definition.emptyBehavior() != null) {
            switch (definition.emptyBehavior()) {
                case ERROR: {
                    sqlAppender.appendSql(" error on empty");
                    break;
                }
                case NULL: {
                    sqlAppender.appendSql(" null on empty");
                    break;
                }
                case EMPTY_OBJECT: {
                    sqlAppender.appendSql(" empty object on empty");
                    break;
                }
                case EMPTY_ARRAY: {
                    sqlAppender.appendSql(" empty array on empty");
                }
            }
        }
    }

    private void renderJsonValueColumnDefinition(SqlAppender sqlAppender, JsonTableValueColumnDefinition definition, @Nullable String jsonPathPrefix, SqlAstTranslator<?> walker) {
        Expression defaultExpression;
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(' ');
        sqlAppender.appendSql(this.determineColumnType(definition.type(), walker));
        this.renderColumnPath(definition.name(), definition.jsonPath(), jsonPathPrefix, sqlAppender, walker);
        if (definition.errorBehavior() != null) {
            if (definition.errorBehavior() == JsonValueErrorBehavior.ERROR) {
                sqlAppender.appendSql(" error on error");
            } else if (definition.errorBehavior() != JsonValueErrorBehavior.NULL) {
                defaultExpression = definition.errorBehavior().getDefaultExpression();
                assert (defaultExpression != null);
                sqlAppender.appendSql(" default ");
                defaultExpression.accept(walker);
                sqlAppender.appendSql(" on error");
            }
        }
        if (definition.emptyBehavior() != null) {
            if (definition.emptyBehavior() == JsonValueEmptyBehavior.ERROR) {
                sqlAppender.appendSql(" error on empty");
            } else if (definition.emptyBehavior() != JsonValueEmptyBehavior.NULL) {
                defaultExpression = definition.emptyBehavior().getDefaultExpression();
                assert (defaultExpression != null);
                sqlAppender.appendSql(" default ");
                defaultExpression.accept(walker);
                sqlAppender.appendSql(" on empty");
            }
        }
    }

    private void renderJsonOrdinalityColumnDefinition(SqlAppender sqlAppender, JsonTableOrdinalityColumnDefinition definition) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(" clob format json path '$'");
    }

    private int renderJsonNestedColumnDefinition(SqlAppender sqlAppender, JsonTableNestedColumnDefinition definition, int clauseLevel) {
        sqlAppender.appendSql("nested_");
        sqlAppender.appendSql(clauseLevel);
        sqlAppender.appendSql("_ clob format json path ");
        String jsonPath = this.isArrayAccess(definition.jsonPath()) ? definition.jsonPath().substring(0, definition.jsonPath().length() - 3) : definition.jsonPath();
        sqlAppender.appendSingleQuoteEscapedString(jsonPath);
        return clauseLevel + this.countNestedColumnDefinitions(definition.columns());
    }

    private void renderJsonExistsColumnDefinition(SqlAppender sqlAppender, JsonTableExistsColumnDefinition definition) {
        sqlAppender.appendSql(definition.name());
        sqlAppender.appendSql(" clob format json path '$'");
    }

    public static class SeriesQueryTransformer
    implements QueryTransformer {
        private final int maxSeriesSize;

        public SeriesQueryTransformer(int maxSeriesSize) {
            this.maxSeriesSize = maxSeriesSize;
        }

        @Override
        public QuerySpec transform(CteContainer cteContainer, QuerySpec querySpec, SqmToSqlAstConverter converter) {
            if (cteContainer.getCteStatement("max_series") == null) {
                cteContainer.addCteStatement(CteGenerateSeriesFunction.CteGenerateSeriesQueryTransformer.createSeriesCte(this.maxSeriesSize, converter));
            }
            return querySpec;
        }
    }
}

