/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.Map;
import org.hibernate.Internal;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.type.AnyType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;

@Internal
public class TypeHelper {
    private TypeHelper() {
    }

    public static void deepCopy(Object[] values, Type[] types, boolean[] copy, Object[] target, SharedSessionContractImplementor session) {
        for (int i = 0; i < types.length; ++i) {
            if (!copy[i]) continue;
            target[i] = values[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || values[i] == PropertyAccessStrategyBackRefImpl.UNKNOWN ? values[i] : types[i].deepCopy(values[i], session.getFactory());
        }
    }

    public static Object[] replace(Object[] original, Object[] target, Type[] types, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) {
        Object[] copied = new Object[original.length];
        for (int i = 0; i < types.length; ++i) {
            copied[i] = original[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i] == PropertyAccessStrategyBackRefImpl.UNKNOWN ? target[i] : (target[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? types[i].replace(original[i], null, session, owner, copyCache) : types[i].replace(original[i], target[i], session, owner, copyCache));
        }
        return copied;
    }

    public static void replace(EntityPersister persister, Object entity, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache) {
        Object[] values = persister.getValues(entity);
        Type[] types = persister.getPropertyTypes();
        for (int i = 0; i < types.length; ++i) {
            Object newValue;
            Object oldValue = values[i];
            if (oldValue == LazyPropertyInitializer.UNFETCHED_PROPERTY || oldValue == PropertyAccessStrategyBackRefImpl.UNKNOWN || (newValue = types[i].replace(values[i], values[i], session, owner, copyCache)) == oldValue) continue;
            persister.setValue(entity, i, newValue);
        }
    }

    public static Object[] replace(Object[] original, Object[] target, Type[] types, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copied = new Object[original.length];
        for (int i = 0; i < types.length; ++i) {
            copied[i] = original[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i] == PropertyAccessStrategyBackRefImpl.UNKNOWN ? target[i] : (target[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? types[i].replace(original[i], null, session, owner, copyCache, foreignKeyDirection) : types[i].replace(original[i], target[i], session, owner, copyCache, foreignKeyDirection));
        }
        return copied;
    }

    public static Object[] replaceAssociations(Object[] original, Object[] target, Type[] types, SharedSessionContractImplementor session, Object owner, Map<Object, Object> copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copied = new Object[original.length];
        for (int i = 0; i < types.length; ++i) {
            Object currentOriginal = original[i];
            if (currentOriginal == LazyPropertyInitializer.UNFETCHED_PROPERTY || currentOriginal == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[i] = target[i];
                continue;
            }
            Type type = types[i];
            if (type instanceof EntityType || type instanceof CollectionType || type instanceof AnyType) {
                copied[i] = types[i].replace(currentOriginal, target[i], session, owner, copyCache, foreignKeyDirection);
                continue;
            }
            if (type instanceof ComponentType) {
                ComponentType compositeType = (ComponentType)type;
                if (target[i] != null) {
                    Object[] objects = TypeHelper.replaceCompositeAssociations(session, copyCache, foreignKeyDirection, target[i], currentOriginal, compositeType);
                    target[i] = compositeType.replacePropertyValues(target[i], objects, session);
                }
            }
            copied[i] = target[i];
        }
        return copied;
    }

    private static Object[] replaceCompositeAssociations(SharedSessionContractImplementor session, Map<Object, Object> copyCache, ForeignKeyDirection foreignKeyDirection, Object target, Object currentOriginal, ComponentType compositeType) {
        Type[] subtypes = compositeType.getSubtypes();
        return TypeHelper.replaceAssociations(currentOriginal == null ? new Object[subtypes.length] : compositeType.getPropertyValues(currentOriginal, session), target == null ? new Object[subtypes.length] : compositeType.getPropertyValues(target, session), subtypes, session, null, copyCache, foreignKeyDirection);
    }
}

