/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.keycloak.client.cli.common.BaseGlobalOptionsCmd;
import org.keycloak.client.cli.util.OsUtil;
import org.keycloak.client.registration.cli.KcRegMain;
import org.keycloak.client.registration.cli.commands.AttrsCmd;
import org.keycloak.client.registration.cli.commands.ConfigCmd;
import org.keycloak.client.registration.cli.commands.CreateCmd;
import org.keycloak.client.registration.cli.commands.DeleteCmd;
import org.keycloak.client.registration.cli.commands.GetCmd;
import org.keycloak.client.registration.cli.commands.HelpCmd;
import org.keycloak.client.registration.cli.commands.UpdateCmd;
import org.keycloak.client.registration.cli.commands.UpdateTokenCmd;
import picocli.CommandLine;

@CommandLine.Command(name="kcreg", header={"Keycloak - Open Source Identity and Access Management", "", "Find more information at: https://www.keycloak.org/docs/latest"}, description={"%nCOMMAND [ARGUMENTS]"}, subcommands={HelpCmd.class, ConfigCmd.class, CreateCmd.class, GetCmd.class, UpdateCmd.class, DeleteCmd.class, AttrsCmd.class, UpdateTokenCmd.class})
public class KcRegCmd
extends BaseGlobalOptionsCmd {
    @Override
    protected boolean nothingToDo() {
        return true;
    }

    @Override
    protected String help() {
        return KcRegCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Keycloak Client Registration CLI");
        out.println();
        out.println("Use '" + KcRegMain.CMD + " config credentials' command with username and password to start a session against a specific");
        out.println("server and realm.");
        out.println();
        out.println("For example:");
        out.println();
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " config credentials --server http://localhost:8080 --realm master --user admin");
        out.println("  Enter password: ");
        out.println("  Logging into http://localhost:8080 as user admin of realm master");
        out.println();
        out.println("Any configured username can be used for login, but to perform client registration operations the user");
        out.println("needs proper roles, otherwise attempts to create, update, read, or delete clients will fail.");
        out.println("Alternatively, the user without the necessary roles can use an Initial Access Token provided by realm");
        out.println("administrator when creating a new client with 'create' command. For example:");
        out.println();
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " create -f my_client.json -t -");
        out.println("  Enter Initial Access Token: ");
        out.println("  Registered new client with client_id 'my_client'");
        out.println();
        out.println("When Initial Access Token is used the server issues a Registration Access Token which is automatically");
        out.println("handled by " + KcRegMain.CMD + ", saved into a local config file, and automatically used for any follow-up operations");
        out.println("on the same client. For example:");
        out.println();
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " get my_client");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " update my_client -s enabled=false");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " delete my_client");
        out.println();
        out.println();
        out.println("Usage: " + KcRegMain.CMD + " COMMAND [ARGUMENTS]");
        out.println();
        out.println("Global options:");
        out.println("  -x            Print full stack trace when exiting with error");
        out.println("  --help        Print help for specific command");
        out.println("  --config      Path to the config file (" + KcRegMain.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println("  --no-config   Don't use config file - no authentication info is loaded or saved");
        out.println();
        out.println("Commands: ");
        out.println("  config        Set up credentials, and other configuration settings using the config file");
        out.println("  create        Register a new client");
        out.println("  get           Get configuration of existing client in Keycloak or OIDC format, or adapter install configuration");
        out.println("  update        Update a client configuration");
        out.println("  delete        Delete a client");
        out.println("  attrs         List available attributes");
        out.println("  update-token  Update Registration Access Token for a client");
        out.println("  help          This help");
        out.println();
        out.println("Use '" + KcRegMain.CMD + " help <command>' for more information about a given command.");
        return sb.toString();
    }
}

