/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.api.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.keycloak.saml.common.constants.GeneralConstants;

public class DeflateUtil {
    public static long DEFAULT_MAX_INFLATING_SIZE = 131072L;

    private DeflateUtil() {
    }

    public static byte[] encode(byte[] message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(8, true);
        DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)baos, deflater);
        deflaterStream.write(message);
        deflaterStream.finish();
        return baos.toByteArray();
    }

    public static byte[] encode(String message) throws IOException {
        return DeflateUtil.encode(message.getBytes(GeneralConstants.SAML_CHARSET));
    }

    public static InputStream decode(byte[] msgToDecode) {
        return DeflateUtil.decode(msgToDecode, DEFAULT_MAX_INFLATING_SIZE);
    }

    public static InputStream decode(byte[] msgToDecode, long maxInflatingSize) {
        ByteArrayInputStream bais = new ByteArrayInputStream(msgToDecode);
        return new LimitedInflaterInputStream(bais, maxInflatingSize);
    }

    private static class LimitedInflaterInputStream
    extends InputStream {
        private final InflaterInputStream is;
        private final Inflater inflater = new Inflater(true);
        private final long maxInflatingSize;

        private LimitedInflaterInputStream(InputStream is, long maxInflatingSize) {
            this.is = new InflaterInputStream(is, this.inflater);
            this.maxInflatingSize = maxInflatingSize;
        }

        private void checkMaxInflatingsize() throws IOException {
            if (this.inflater.getBytesWritten() > this.maxInflatingSize) {
                throw new IOException(String.format("Maximum inflating size %d reached. Total bytes witten %d.", this.maxInflatingSize, this.inflater.getTotalOut()));
            }
        }

        @Override
        public int read() throws IOException {
            int result = this.is.read();
            this.checkMaxInflatingsize();
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.is.read(b, off, len);
            this.checkMaxInflatingsize();
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int result = this.is.read(b);
            this.checkMaxInflatingsize();
            return result;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }
    }
}

