/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CDirectPathPreparedStatement;
import oracle.jdbc.driver.T4CMAREngine;

final class DirectPathBufferMarshaler {
    private static final byte KPCDP_STR_RHDR_OVERFLOW = -128;
    private static final byte KPCDP_STR_RHDR_ERROR = 64;
    private static final byte KPCDP_STR_RHDR_FRC = 32;
    private static final byte KPCDP_STR_RHDR_FAST = 16;
    private static final byte KPCDP_STR_RHDR_FIRST = 8;
    private static final byte KPCDP_STR_RHDR_LAST = 4;
    private static final byte KPCDP_STR_RHDR_PREV = 2;
    private static final byte KPCDP_STR_RHDR_NEXT = 1;
    private static final byte FRC_HEADER_FLAGS = 60;
    private static final short KDRCSSHC = 250;
    private static final short KDRCSLNG = 254;
    private static final short KDRCSNUL = 255;
    private static final short KPCDP_STR_CLEN_NULL = -1;
    private static final short KPCDP_STR_BYTE_CLEN_NULL = 255;
    private static final short KPCDP_STR_CLEN_FOLLOWS = 254;
    private static final short KPCDP_STR_CLEN_EMPTY = -2;
    private static final short KPCDP_STR_CLEN_ADT = -3;
    private static final short KPCDP_STR_CLEN_ALIGN = -4;
    private static final int KPCDP_STR_CLEN_MAX = 65520;
    private static final short KPCDP_STR_BYTE_CLEN_MAX = 250;
    private static final short KPCDP_STR_SUBTYPE_INDEX_LEN = 2;
    private static final int MAX_PIECE_SIZE = 65520;
    private static final int FAST_HEADER_SIZE = 4;
    private static final int MAX_FAST_DATA = 65516;
    private static final int SLOW_HEADER_SIZE = 2;
    private static final short MAX_PIECE_COLUMNS = 255;
    private static final int MAX_DATA_LENGTH_ENCODING = 3;
    private static final int MAX_DATA_LENGTH = 65513;
    private static final int STREAM_BUFFER_SIZE = 131072;

    private DirectPathBufferMarshaler() {
    }

    static BufferPlanner createBufferPlanner(int numberOfRows, int numberOfBindPositions, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, InputStream[][] bindDataStreams, Accessor[] accessors, PhysicalConnection connection) throws IOException {
        DataSegmentSequence dataStream = new DataSegmentSequence(numberOfBindPositions, numberOfRows, (DynamicByteArray)bindData, bindDataLengths, bindDataOffsets, bindDataStreams, () -> connection.getByteBuffer(131072), buffer -> connection.cacheBuffer((byte[])buffer));
        return new BufferPlanner(numberOfRows, numberOfBindPositions, DirectPathBufferMarshaler.calculateFastColumns(accessors), dataStream);
    }

    static void marshal(BufferPlanner plan, T4CMAREngine meg) throws IOException {
        RowPieceCursor pieceCursor = plan.cursor();
        while (pieceCursor.nextPiece()) {
            int dataLength;
            DirectPathBufferMarshaler.marshalHeader(pieceCursor, meg);
            while (0 <= (dataLength = pieceCursor.nextData())) {
                if (pieceCursor.isDataNull()) {
                    DirectPathBufferMarshaler.marshalNullDataLength(meg);
                } else {
                    DirectPathBufferMarshaler.marshalDataLength(dataLength, meg);
                }
                pieceCursor.writeData(meg);
            }
        }
    }

    private static void marshalHeader(RowPieceCursor cursor, T4CMAREngine meg) throws IOException {
        if (cursor.isFirst() && cursor.isLast() && cursor.isFast()) {
            meg.marshalUB1((short)60);
            meg.marshalNativeUB2((short)cursor.getRowSize(), false);
        } else {
            int flags = 0;
            if (cursor.isFirst()) {
                flags = (byte)(flags | 8);
            } else if (cursor.splitsWithPrevious()) {
                flags = (byte)(flags | 2);
            }
            if (cursor.isLast()) {
                flags = (byte)(flags | 4);
            } else if (cursor.splitsWithNext()) {
                flags = (byte)(flags | 1);
            }
            meg.marshalUB1((short)flags);
        }
        meg.marshalUB1((byte)cursor.getDataCount());
    }

    private static void marshalDataLength(int length, T4CMAREngine meg) throws IOException {
        if (DirectPathBufferMarshaler.sizeOfColumnLength(length) == 1) {
            meg.marshalUB1((byte)length);
        } else {
            meg.marshalUB1((short)-2);
            meg.marshalNativeUB2((short)length, false);
        }
    }

    private static void marshalNullDataLength(T4CMAREngine meg) throws IOException {
        meg.marshalUB1((short)-1);
    }

    private static int sizeOfColumnLength(int colDataLen) {
        return colDataLen <= 250 ? 1 : 3;
    }

    private static boolean calculateFastColumns(Accessor[] accessors) {
        boolean isFast = true;
        for (int i = 0; isFast && i < accessors.length; ++i) {
            isFast = DirectPathBufferMarshaler.isFastType(accessors[i].describeType);
        }
        return isFast;
    }

    private static boolean isFastType(int typeCode) {
        return typeCode == 1 || typeCode == 96 || typeCode == 178 || typeCode == 185 || typeCode == 179 || typeCode == 186 || typeCode == 180 || typeCode == 187 || typeCode == 231 || typeCode == 232 || typeCode == 181 || typeCode == 188 || typeCode == 182 || typeCode == 189 || typeCode == 183 || typeCode == 190 || typeCode == 2 || typeCode == 12 || typeCode == 23 || typeCode == 100 || typeCode == 101 || typeCode == 121;
    }

    private static int[] growAndSet(int[] array, int index, int value) {
        int[] ret = DirectPathBufferMarshaler.growToIndex(Integer.TYPE, array, index);
        ret[index] = value;
        return ret;
    }

    private static byte[] growAndSet(byte[] array, int index, byte value) {
        byte[] ret = DirectPathBufferMarshaler.growToIndex(Byte.TYPE, array, index);
        ret[index] = value;
        return ret;
    }

    private static <T> T growToIndex(Class<?> type, T array, int index) {
        Object ret;
        int length = Array.getLength(array);
        if (length > index) {
            ret = array;
        } else {
            int newLength = Math.max(index, length + (length >> 1)) + 1;
            ret = Array.newInstance(type, newLength);
            System.arraycopy(array, 0, ret, 0, length);
        }
        return ret;
    }

    private static class DataSegmentSequence {
        private int dataLimit;
        private int dataIndex;
        private int bindLimit;
        private int bindIndex;
        private final int[] directLengths;
        private final long[] directOffsets;
        private final DynamicByteArray directBindData;
        private int streamLimit;
        private int streamIndex;
        private int[] streamLengths;
        private final Supplier<byte[]> bufferSupplier;
        private final Consumer<byte[]> bufferRecycler;
        private byte[] streamBuffer;
        private int streamBufferReadPos;
        private int streamBufferWritePos;
        private boolean streamBufferIsFull;
        private final InputStream[][] bindStreams;
        private final int columnLimit;
        private final int totalBindCount;
        private int[] splits;
        private int splitLimit;
        private byte[] tempBuf1;

        private DataSegmentSequence(int columnLimit, int rowLimit, DynamicByteArray directBindData, int[] directLengths, long[] directOffsets, InputStream[][] bindStreams, Supplier<byte[]> bufferSupplier, Consumer<byte[]> bufferRecycler) {
            this.columnLimit = columnLimit;
            this.totalBindCount = columnLimit * rowLimit;
            this.directBindData = directBindData;
            this.directLengths = directLengths;
            this.directOffsets = directOffsets;
            this.bindStreams = bindStreams;
            this.bufferRecycler = bufferRecycler;
            this.bufferSupplier = bufferSupplier;
        }

        private int addSegment(int maxLength) throws IOException {
            int nextLength;
            if (this.streamBufferIsFull) {
                throw new IllegalStateException("Need to flush data before pushing more.");
            }
            if (this.bindLimit == this.totalBindCount) {
                throw new IllegalStateException("There is no more data to push.");
            }
            if (this.isStream(this.bindLimit)) {
                if (this.readStreamedBind(this.bindLimit, maxLength)) {
                    ++this.bindLimit;
                } else {
                    this.setSplit(this.dataLimit);
                }
                nextLength = this.streamLengths[this.streamLimit - 1];
            } else if ((nextLength = this.directLengths[this.bindLimit++]) > maxLength) {
                throw new UnsupportedOperationException("Splitting direct binds is not supported");
            }
            ++this.dataLimit;
            return nextLength;
        }

        private boolean isRowPushed(int rowIndex) {
            return this.bindLimit >= this.columnLimit * (rowIndex + 1);
        }

        private boolean isSplit(int offset) {
            return this.splits != null && Arrays.binarySearch(this.splits, 0, this.splitLimit, this.dataIndex + offset) >= 0;
        }

        private int nextWriteLength() {
            if (this.dataIndex >= this.dataLimit) {
                return -1;
            }
            if (this.isStream(this.bindIndex)) {
                return this.streamLengths[this.streamIndex];
            }
            return this.directLengths[this.bindIndex];
        }

        private boolean isNextNull() {
            return this.directOffsets[this.bindIndex] == -1L;
        }

        private void write(T4CMAREngine meg) throws IOException {
            if (this.dataIndex >= this.dataLimit) {
                throw new IllegalStateException("There are no data segments left to write.");
            }
            if (!this.isNextNull()) {
                if (this.isStream(this.bindIndex)) {
                    this.writeStreamedBind(meg);
                } else {
                    this.writeDirectBind(meg);
                }
            }
            if (!this.isSplit(0)) {
                ++this.bindIndex;
            }
            ++this.dataIndex;
        }

        private boolean isFull() {
            return this.streamBufferIsFull;
        }

        private void writeDirectBind(T4CMAREngine meg) throws IOException {
            this.directBindData.marshalB1Array(meg, this.directOffsets[this.bindIndex], this.directLengths[this.bindIndex]);
        }

        private boolean readStreamedBind(int streamBindIndex, int maxLength) throws IOException {
            if (this.streamBuffer == null) {
                this.streamBuffer = this.bufferSupplier.get();
            }
            if (this.streamLengths == null) {
                this.streamLengths = new int[2];
            }
            int streamedBindPosition = this.streamBufferWritePos;
            InputStream stream = this.bindStreams[streamBindIndex / this.columnLimit][streamBindIndex % this.columnLimit];
            int rem = Math.min(maxLength, this.streamBuffer.length - this.streamBufferWritePos);
            if (this.tempBuf1 != null) {
                System.arraycopy(this.tempBuf1, 0, this.streamBuffer, this.streamBufferWritePos++, 1);
                --rem;
                this.tempBuf1 = null;
            }
            int more = -1;
            while (rem > 0 && (more = stream.read(this.streamBuffer, this.streamBufferWritePos, rem)) != -1) {
                this.streamBufferWritePos += more;
                rem -= more;
            }
            this.streamBufferIsFull = this.streamBuffer.length == this.streamBufferWritePos;
            int readLength = this.streamBufferWritePos - streamedBindPosition;
            this.streamLengths = DirectPathBufferMarshaler.growAndSet(this.streamLengths, this.streamLimit++, readLength);
            if (more < 0) {
                return true;
            }
            int oneMore = stream.read();
            if (oneMore < 0) {
                return true;
            }
            this.tempBuf1 = new byte[]{(byte)oneMore};
            return false;
        }

        private void writeStreamedBind(T4CMAREngine meg) throws IOException {
            int length = this.streamLengths[this.streamIndex];
            meg.marshalB1Array(this.streamBuffer, this.streamBufferReadPos, length);
            this.streamBufferReadPos += length;
            if (++this.streamIndex == this.streamLimit) {
                this.resetStreamBuffer();
            }
        }

        private boolean isStream(int index) {
            if (this.bindStreams == null) {
                return false;
            }
            int row = index / this.columnLimit;
            int column = index % this.columnLimit;
            return this.bindStreams.length > row && this.bindStreams[row] != null && this.bindStreams[row].length > column && this.bindStreams[row][column] != null;
        }

        private void setSplit(int index) {
            if (this.splits == null) {
                this.splits = new int[2];
            }
            this.splits = DirectPathBufferMarshaler.growAndSet(this.splits, this.splitLimit++, index);
        }

        private void resetStreamBuffer() {
            this.bufferRecycler.accept(this.streamBuffer);
            this.streamBuffer = null;
            this.streamBufferReadPos = 0;
            this.streamBufferWritePos = 0;
            this.streamBufferIsFull = false;
            this.streamIndex = 0;
            this.streamLimit = 0;
        }
    }

    private static class RowPieceCursor {
        private int rowIndex;
        private int pieceIndex;
        private int pieceIndexOfRow;
        private boolean isFirstPieceOfRow;
        private boolean isLastPieceOfRow;
        private int dataIndex;
        private int dataLimit;
        private boolean splitFromPrevious;
        private boolean splitToNext;
        private final BufferPlanner rowPiecePlan;
        private final DataSegmentSequence dataStream;

        private RowPieceCursor(BufferPlanner rowPiecePlan, DataSegmentSequence dataStream) {
            this.rowPiecePlan = rowPiecePlan;
            this.dataStream = dataStream;
            this.dataIndex = -1;
            this.dataLimit = 0;
            this.pieceIndex = -1;
            this.isLastPieceOfRow = true;
            this.rowIndex = -1;
        }

        private boolean nextPiece() {
            if (this.dataIndex + 1 != this.dataLimit) {
                throw new IllegalStateException("Unwritten data remains for the current piece.");
            }
            if (this.pieceIndex + 1 < this.rowPiecePlan.getPieceCount()) {
                ++this.pieceIndex;
                this.isFirstPieceOfRow = this.isLastPieceOfRow;
                if (this.isFirstPieceOfRow) {
                    ++this.rowIndex;
                    this.pieceIndexOfRow = 0;
                } else {
                    ++this.pieceIndexOfRow;
                }
                this.isLastPieceOfRow = this.pieceIndexOfRow + 1 == this.rowPiecePlan.getPieceCount(this.rowIndex) && this.dataStream.isRowPushed(this.rowIndex);
                this.dataIndex = -1;
                this.dataLimit = this.rowPiecePlan.getDataCount(this.pieceIndex);
                this.splitFromPrevious = this.splitToNext;
                this.splitToNext = this.dataStream.isSplit(this.dataLimit - 1);
                return true;
            }
            this.pieceIndexOfRow = -1;
            return false;
        }

        private int nextData() {
            if (this.dataIndex + 1 < this.dataLimit) {
                ++this.dataIndex;
                return this.dataStream.nextWriteLength();
            }
            return -1;
        }

        private boolean isDataNull() {
            return this.dataStream.isNextNull();
        }

        private void writeData(T4CMAREngine meg) throws IOException {
            if (this.dataIndex >= this.dataLimit) {
                throw new IllegalStateException("No remaining data to write for the current piece.");
            }
            this.dataStream.write(meg);
        }

        private boolean isFirst() {
            return this.isFirstPieceOfRow;
        }

        private boolean isLast() {
            return this.isLastPieceOfRow;
        }

        private boolean isFast() {
            return this.rowPiecePlan.allFastTypes();
        }

        private int getDataCount() {
            return this.dataLimit;
        }

        private int getRowSize() {
            return this.rowPiecePlan.rowSizes[this.rowIndex];
        }

        private boolean splitsWithPrevious() {
            return this.splitFromPrevious;
        }

        private boolean splitsWithNext() {
            return this.splitToNext;
        }
    }

    static class BufferPlanner {
        private final boolean allFastTypes;
        private final int[] pieceCounts;
        private final int[] rowSizes;
        private final DataSegmentSequence dataSequence;
        private int totalPieceCount;
        private int pushBytesRemaining;
        private int pushedBytesTotal;
        private byte[] dataCounts;
        private int rowLimit;
        private final int totalRows;
        private RowPieceCursor cursor;

        private BufferPlanner(int totalRows, int totalColumns, boolean allFastTypes, DataSegmentSequence dataSequence) {
            this.totalRows = totalRows;
            this.allFastTypes = allFastTypes;
            this.dataSequence = dataSequence;
            this.pieceCounts = new int[totalRows];
            this.rowSizes = new int[totalRows];
            this.dataCounts = new byte[totalRows + 1];
        }

        int preparePlan() throws IOException, T4CDirectPathPreparedStatement.StreamLengthException {
            this.resetPushState();
            while (this.pushData() || this.pushPiece() || this.pushRow()) {
            }
            return this.pushedBytesTotal;
        }

        boolean isComplete() {
            return this.rowLimit == this.totalRows;
        }

        int getRowByOffset(int startOffset, int endOffset) {
            int rowInError = 0;
            if ((startOffset != 0 || endOffset != 0) && this.rowSizes != null && this.rowSizes.length > 0) {
                int rowStartOffset = 0;
                int rowEndOffset = 0;
                for (int row = 0; row < this.rowSizes.length; ++row) {
                    if (startOffset >= rowStartOffset && endOffset <= (rowEndOffset += this.rowSizes[row])) {
                        rowInError = row + 1;
                        break;
                    }
                    rowStartOffset = rowEndOffset;
                }
            }
            return rowInError;
        }

        private RowPieceCursor cursor() {
            if (this.cursor == null) {
                this.cursor = new RowPieceCursor(this, this.dataSequence);
            }
            return this.cursor;
        }

        private boolean pushData() throws IOException {
            int currentDataCount = this.getDataCount(this.totalPieceCount);
            if (this.dataSequence.isRowPushed(this.rowLimit)) {
                return false;
            }
            if (currentDataCount == 255) {
                return false;
            }
            if (this.dataSequence.isFull()) {
                return false;
            }
            int dataLength = this.dataSequence.addSegment(65513);
            int prefixedDataLength = DirectPathBufferMarshaler.sizeOfColumnLength(dataLength) + dataLength;
            if (prefixedDataLength > this.pushBytesRemaining) {
                if (currentDataCount > 0) {
                    this.pushPiece();
                } else {
                    throw new IllegalStateException("Data will not fit in an empty piece.");
                }
            }
            this.pushBytesRemaining -= prefixedDataLength;
            int n = this.rowLimit;
            this.rowSizes[n] = this.rowSizes[n] + prefixedDataLength;
            int n2 = this.totalPieceCount;
            this.dataCounts[n2] = (byte)(this.dataCounts[n2] + 1);
            return true;
        }

        private boolean pushPiece() {
            if (this.getDataCount(this.totalPieceCount) > 0) {
                int n = this.rowLimit;
                this.pieceCounts[n] = this.pieceCounts[n] + 1;
                this.dataCounts = DirectPathBufferMarshaler.growToIndex(Byte.TYPE, this.dataCounts, ++this.totalPieceCount);
            }
            this.pushBytesRemaining = 65516;
            return !this.dataSequence.isFull() && !this.dataSequence.isRowPushed(this.rowLimit);
        }

        private boolean pushRow() {
            boolean fullRow = this.dataSequence.isRowPushed(this.rowLimit);
            int pieceCountForRow = this.pieceCounts[this.rowLimit];
            if (pieceCountForRow > 0) {
                if (pieceCountForRow == 1 && fullRow && this.allFastTypes) {
                    int n = this.rowLimit;
                    this.rowSizes[n] = this.rowSizes[n] + 4;
                } else {
                    int n = this.rowLimit;
                    this.rowSizes[n] = this.rowSizes[n] + 2 * pieceCountForRow;
                }
                this.pushedBytesTotal += this.rowSizes[this.rowLimit];
            }
            if (fullRow) {
                ++this.rowLimit;
            }
            return this.rowLimit != this.totalRows && !this.dataSequence.isFull();
        }

        private void resetPushState() {
            this.pushedBytesTotal = 0;
            this.pushBytesRemaining = 65516;
            if (this.rowLimit >= 0) {
                this.pieceCounts[this.rowLimit] = 0;
                this.rowSizes[this.rowLimit] = 0;
            }
        }

        private boolean allFastTypes() {
            return this.allFastTypes;
        }

        private int getDataCount(int pieceIndex) {
            return this.dataCounts[pieceIndex] & 0xFF;
        }

        private int getPieceCount(int rowIndex) {
            return this.pieceCounts[rowIndex];
        }

        private int getPieceCount() {
            return this.totalPieceCount;
        }
    }
}

