/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CCallableStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CInputStream;
import oracle.jdbc.driver.T4CPreparedStatement;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

class T4CDriverExtension
extends OracleDriverExtension
implements Monitor {
    private OracleDriverExtension shardingDriverExtension = null;
    private static String shardingDriverExtensionClassName = "oracle.jdbc.driver.ShardingDriverExtension";
    private OracleDriverExtension tcDriverExtension = null;
    private static final String tcDriverExtensionClassName = "oracle.jdbc.driver.TrueCacheDriverExtension";
    private static final Monitor DEFAULT_CONN_MONITOR = Monitor.newInstance();
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    T4CDriverExtension() {
    }

    @Override
    final Connection getConnection(String url, @Blind(value=PropertiesBlinder.class) Properties info, AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        T4CConnection conn = new T4CConnection(url, info, this);
        try (Monitor.CloseableLock connLock = conn.acquireCloseableLock();){
            if (conn.useTrueCacheDriverConnection() && !conn.isTrueCacheDriverMode()) {
                if (this.tcDriverExtension == null) {
                    try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                        if (this.tcDriverExtension == null) {
                            this.tcDriverExtension = (OracleDriverExtension)Class.forName(tcDriverExtensionClassName).newInstance();
                        }
                    }
                    catch (Exception ex) {
                        throw new SQLException(ex);
                    }
                }
                Connection ex = this.tcDriverExtension.getConnection(url, info, builder);
                return ex;
            }
            if (conn.useShardingDriverConnection() && !conn.isShardingDriverMode()) {
                AutoCloseable lock2;
                if (this.shardingDriverExtension == null) {
                    try {
                        lock2 = this.acquireCloseableLock();
                        try {
                            if (this.shardingDriverExtension == null) {
                                this.shardingDriverExtension = (OracleDriverExtension)Class.forName(shardingDriverExtensionClassName).newInstance();
                            }
                        }
                        finally {
                            if (lock2 != null) {
                                ((Monitor.CloseableLock)lock2).close();
                            }
                        }
                    }
                    catch (Exception lock2) {
                        // empty catch block
                    }
                }
                lock2 = this.shardingDriverExtension.getConnection(url, info, builder);
                return lock2;
            }
            conn.connect(builder);
            T4CConnection lock2 = conn;
            return lock2;
        }
    }

    final CompletionStage<T4CConnection> getConnectionAsync(String url, @Blind(value=PropertiesBlinder.class) Properties info, AbstractConnectionBuilder<?, ?> builder) {
        try {
            T4CConnection conn = new T4CConnection(url, info, this);
            return conn.connectAsync(builder).thenApply(nil -> conn);
        }
        catch (SQLException preConnectFailure) {
            return CompletionStageUtil.failedStage(preConnectFailure);
        }
    }

    @Override
    T4CStatement allocateStatement(OracleConnection connection, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        return new T4CStatement((PhysicalConnection)connection, resultSetType);
    }

    @Override
    T4CPreparedStatement allocatePreparedStatement(OracleConnection connection, String sql, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        return new T4CPreparedStatement((PhysicalConnection)connection, sql, resultSetType);
    }

    @Override
    T4CPreparedStatement allocatePreparedStatement(OracleConnection connection, String sql, AutoKeyInfo autoKeyInfo) throws SQLException {
        return new T4CPreparedStatement((PhysicalConnection)connection, sql, autoKeyInfo);
    }

    @Override
    T4CCallableStatement allocateCallableStatement(OracleConnection connection, String sql, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        return new T4CCallableStatement((PhysicalConnection)connection, sql, resultSetType);
    }

    @Override
    T4CInputStream createInputStream(OracleStatement stmt, int index, Accessor accessor) throws SQLException {
        return new T4CInputStream(stmt, index, accessor);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

