/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.opensearch.ingest.Pipeline;
import reactor.util.annotation.NonNull;

public class SystemIngestPipelineCache {
    private final Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private final int MAX_ENTRIES = 100;
    private final long EXPIRES_IN_MINUTES = 60L;

    public void cachePipeline(@NonNull String index, @NonNull Pipeline systemIngestPipeline, int maxIngestProcessorCount) {
        if (systemIngestPipeline.getProcessors().size() > maxIngestProcessorCount) {
            throw new IllegalArgumentException("Too many system ingest processors for index: " + index);
        }
        if (this.cache.size() >= 100) {
            this.evictOldestAndExpiredCacheEntry();
        }
        this.cache.put(index, new CacheEntry(this, systemIngestPipeline));
    }

    private void evictOldestAndExpiredCacheEntry() {
        String oldestIndex = null;
        long oldestTimestamp = Long.MAX_VALUE;
        ArrayList<String> expiredIndices = new ArrayList<String>();
        for (Map.Entry<String, CacheEntry> entry : this.cache.entrySet()) {
            CacheEntry cacheEntry = entry.getValue();
            if (cacheEntry.getLastAccessTimestamp() < oldestTimestamp) {
                oldestTimestamp = cacheEntry.getLastAccessTimestamp();
                oldestIndex = entry.getKey();
            }
            if (!cacheEntry.isExpired()) continue;
            expiredIndices.add(entry.getKey());
        }
        if (oldestIndex != null) {
            this.cache.remove(oldestIndex);
        }
        for (String expiredIndex : expiredIndices) {
            this.cache.remove(expiredIndex);
        }
    }

    public Pipeline getSystemIngestPipeline(String index) {
        CacheEntry entry = this.cache.get(index);
        if (entry != null) {
            if (entry.isExpired()) {
                this.cache.remove(index);
                return null;
            }
            entry.setLastAccessTimestamp(System.currentTimeMillis());
            return entry.getSystemIngestPipeline();
        }
        return null;
    }

    public int size() {
        return this.cache.size();
    }

    public void invalidateCacheForIndex(@NonNull String index) {
        this.cache.remove(index);
    }

    private class CacheEntry {
        private final Pipeline systemIngestPipeline;
        private final long createTimestamp;
        private long lastAccessTimestamp;

        public CacheEntry(SystemIngestPipelineCache systemIngestPipelineCache, Pipeline systemIngestPipeline) {
            this.systemIngestPipeline = systemIngestPipeline;
            this.lastAccessTimestamp = this.createTimestamp = System.currentTimeMillis();
        }

        public Pipeline getSystemIngestPipeline() {
            return this.systemIngestPipeline;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.createTimestamp > TimeUnit.MINUTES.toMillis(60L);
        }

        public void setLastAccessTimestamp(long lastAccessTimestamp) {
            this.lastAccessTimestamp = lastAccessTimestamp;
        }

        public long getLastAccessTimestamp() {
            return this.lastAccessTimestamp;
        }
    }
}

