/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.DhPublicKeyParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MqvPublicParameters
implements CipherParameters {
    private DhPublicKeyParameters staticPublicKey;
    private DhPublicKeyParameters ephemeralPublicKey;

    public MqvPublicParameters(DhPublicKeyParameters dhPublicKeyParameters, DhPublicKeyParameters dhPublicKeyParameters2) {
        this.staticPublicKey = dhPublicKeyParameters;
        this.ephemeralPublicKey = dhPublicKeyParameters2;
        if (!dhPublicKeyParameters.getParameters().equals(dhPublicKeyParameters2.getParameters())) {
            throw new IllegalKeyException("Static and ephemeral keys have different domain parameters");
        }
    }

    public DhPublicKeyParameters getStaticPublicKey() {
        return this.staticPublicKey;
    }

    public DhPublicKeyParameters getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }
}

