/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.setup;

import java.util.Collection;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.StepListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.replication.action.setup.SetupChecksRequest;
import org.opensearch.replication.action.setup.ValidatePermissionsAction;
import org.opensearch.replication.action.setup.ValidatePermissionsRequest;
import org.opensearch.replication.metadata.store.ReplicationContext;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.ActionNotFoundTransportException;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 !2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001!B1\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0014J6\u0010\u0019\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/opensearch/replication/action/setup/TransportSetupChecksAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/replication/action/setup/SetupChecksRequest;", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;)V", "getThreadPool", "()Lorg/opensearch/threadpool/ThreadPool;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "triggerPermissionsValidation", "cluster", "", "replContext", "Lorg/opensearch/replication/metadata/store/ReplicationContext;", "shouldValidateRole", "", "permissionListener", "Companion", "opensearch-cross-cluster-replication"})
public final class TransportSetupChecksAction
extends HandledTransportAction<SetupChecksRequest, AcknowledgedResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    private static final Logger log = LogManager.getLogger(TransportSetupChecksAction.class);

    @Inject
    public TransportSetupChecksAction(@NotNull TransportService transportService, @NotNull ThreadPool threadPool, @NotNull ActionFilters actionFilters, @NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        super("internal:indices/admin/plugins/replication/index/setup", transportService, actionFilters, SetupChecksRequest::new);
        this.threadPool = threadPool;
        this.client = client;
        this.clusterService = clusterService;
    }

    @NotNull
    public final ThreadPool getThreadPool() {
        return this.threadPool;
    }

    protected void doExecute(@NotNull Task task, @NotNull SetupChecksRequest request, @NotNull ActionListener<AcknowledgedResponse> listener2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Ref.ObjectRef leaderClusterClient = new Ref.ObjectRef();
        String followerClusterName = this.clusterService.getClusterName().value();
        try {
            leaderClusterClient.element = this.client.getRemoteClusterClient(request.getConnectionName());
        }
        catch (Exception e) {
            log.info("Failed to connect to remote cluster " + request + ".connectionName with error " + e);
            listener2.onFailure(e);
            return;
        }
        if (request.getFollowerContext().getUser() != null) {
            User user = request.getFollowerContext().getUser();
            Intrinsics.checkNotNull((Object)user);
            if (user.getRoles().isEmpty()) {
                log.info("User roles are empty for follower_resource:" + request.getFollowerContext().getResource());
                listener2.onFailure((Exception)new OpenSearchSecurityException("Follower roles are mandatory for replication", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
        }
        if (request.getLeaderContext().getUser() != null) {
            User user = request.getLeaderContext().getUser();
            Intrinsics.checkNotNull((Object)user);
            if (user.getRoles().isEmpty()) {
                log.info("User roles are empty for leader_resource:" + request.getLeaderContext().getResource());
                listener2.onFailure((Exception)new OpenSearchSecurityException("Leader roles are mandatory for replication", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
        }
        StepListener userPermissionsValidationAtLocal = new StepListener();
        StepListener userPermissionsValidationAtRemote = new StepListener();
        StepListener rolePermissionsValidationAtLocal = new StepListener();
        StepListener rolePermissionsValidationAtRemote = new StepListener();
        rolePermissionsValidationAtRemote.whenComplete(arg_0 -> TransportSetupChecksAction.doExecute$lambda$0(request, listener2, arg_0), arg_0 -> TransportSetupChecksAction.doExecute$lambda$1(request, listener2, arg_0));
        rolePermissionsValidationAtLocal.whenComplete(arg_0 -> TransportSetupChecksAction.doExecute$lambda$2(request, this, leaderClusterClient, rolePermissionsValidationAtRemote, arg_0), arg_0 -> TransportSetupChecksAction.doExecute$lambda$3(followerClusterName, request, listener2, arg_0));
        userPermissionsValidationAtRemote.whenComplete(arg_0 -> TransportSetupChecksAction.doExecute$lambda$4(request, this, followerClusterName, rolePermissionsValidationAtLocal, arg_0), arg_0 -> TransportSetupChecksAction.doExecute$lambda$5(request, listener2, arg_0));
        userPermissionsValidationAtLocal.whenComplete(arg_0 -> TransportSetupChecksAction.doExecute$lambda$6(followerClusterName, request, this, leaderClusterClient, userPermissionsValidationAtRemote, arg_0), arg_0 -> TransportSetupChecksAction.doExecute$lambda$7(followerClusterName, request, listener2, arg_0));
        Intrinsics.checkNotNull((Object)followerClusterName);
        this.triggerPermissionsValidation(this.client, followerClusterName, request.getFollowerContext(), false, (ActionListener<AcknowledgedResponse>)((ActionListener)userPermissionsValidationAtLocal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void triggerPermissionsValidation(Client client, String cluster, ReplicationContext replContext, boolean shouldValidateRole, ActionListener<AcknowledgedResponse> permissionListener) {
        ThreadContext.StoredContext storedContext = null;
        try {
            storedContext = client.threadPool().getThreadContext().newStoredContext(false, (Collection)CollectionsKt.listOf((Object)"opendistro_security_injected_roles_validation"));
            Object object = replContext.getUser();
            String validateRole = object != null && (object = object.getRoles()) != null ? (String)object.get(0) : null;
            String inThreadContextRole = (String)client.threadPool().getThreadContext().getTransient("opendistro_security_injected_roles_validation");
            log.debug("Validation role in threadcontect is " + inThreadContextRole + " for " + cluster);
            if (shouldValidateRole) {
                client.threadPool().getThreadContext().putTransient("opendistro_security_injected_roles_validation", (Object)validateRole);
            }
            ValidatePermissionsRequest validateReq = new ValidatePermissionsRequest(cluster, replContext.getResource(), validateRole);
            client.execute((ActionType)ValidatePermissionsAction.Companion.getINSTANCE(), (ActionRequest)validateReq, permissionListener);
        }
        finally {
            ThreadContext.StoredContext storedContext2 = storedContext;
            if (storedContext2 != null) {
                storedContext2.close();
            }
        }
    }

    private static final void doExecute$lambda$0(SetupChecksRequest $request, ActionListener $listener, AcknowledgedResponse r) {
        log.info("Permissions validation successful for role [connection:" + $request.getConnectionName() + ", resource:" + $request.getLeaderContext().getResource() + "]");
        $listener.onResponse((Object)r);
    }

    private static final void doExecute$lambda$1(SetupChecksRequest $request, ActionListener $listener, Exception e) {
        Exception exceptionToThrow = e;
        if (e instanceof RemoteTransportException && ((RemoteTransportException)e).getCause() instanceof ActionNotFoundTransportException) {
            exceptionToThrow = new UnsupportedOperationException("Replication is not enabled on the remote domain");
        }
        String string = $request.getConnectionName();
        String string2 = $request.getLeaderContext().getResource();
        Exception exception = exceptionToThrow;
        Intrinsics.checkNotNull((Object)exception);
        log.error("Permissions validation failed for role [connection:" + string + ", resource:" + string2 + "] with " + ExtensionsKt.stackTraceToString(exception));
        exception = exceptionToThrow;
        Intrinsics.checkNotNull((Object)exception);
        $listener.onFailure(Companion.unwrapSecurityExceptionIfPresent(exception));
    }

    private static final void doExecute$lambda$2(SetupChecksRequest $request, TransportSetupChecksAction this$0, Ref.ObjectRef $leaderClusterClient, StepListener $rolePermissionsValidationAtRemote, AcknowledgedResponse it) {
        log.info("Permissions validation successful for User [connection:" + $request.getConnectionName() + ", resource:" + $request.getLeaderContext().getResource() + "]");
        Object object = $leaderClusterClient.element;
        Intrinsics.checkNotNull((Object)object);
        this$0.triggerPermissionsValidation((Client)object, $request.getConnectionName(), $request.getLeaderContext(), true, (ActionListener<AcknowledgedResponse>)((ActionListener)$rolePermissionsValidationAtRemote));
    }

    private static final void doExecute$lambda$3(String $followerClusterName, SetupChecksRequest $request, ActionListener $listener, Exception e) {
        String string = $request.getFollowerContext().getResource();
        Intrinsics.checkNotNull((Object)e);
        log.error("Permissions validation failed for role [local:" + $followerClusterName + ", resource:" + string + "] with " + ExtensionsKt.stackTraceToString(e));
        $listener.onFailure(Companion.unwrapSecurityExceptionIfPresent(e));
    }

    private static final void doExecute$lambda$4(SetupChecksRequest $request, TransportSetupChecksAction this$0, String $followerClusterName, StepListener $rolePermissionsValidationAtLocal, AcknowledgedResponse it) {
        log.info("Permissions validation successful for User [connection:" + $request.getConnectionName() + ", resource:" + $request.getLeaderContext().getResource() + "]");
        Client client = this$0.client;
        Intrinsics.checkNotNull((Object)$followerClusterName);
        this$0.triggerPermissionsValidation(client, $followerClusterName, $request.getFollowerContext(), true, (ActionListener<AcknowledgedResponse>)((ActionListener)$rolePermissionsValidationAtLocal));
    }

    private static final void doExecute$lambda$5(SetupChecksRequest $request, ActionListener $listener, Exception e) {
        Exception exceptionToThrow = e;
        if (e instanceof RemoteTransportException && ((RemoteTransportException)e).getCause() instanceof ActionNotFoundTransportException) {
            exceptionToThrow = new UnsupportedOperationException("Replication is not enabled on the remote domain");
        }
        String string = $request.getConnectionName();
        String string2 = $request.getLeaderContext().getResource();
        Exception exception = exceptionToThrow;
        Intrinsics.checkNotNull((Object)exception);
        log.error("Permissions validation failed for User [connection:" + string + ", resource:" + string2 + "] with " + ExtensionsKt.stackTraceToString(exception));
        exception = exceptionToThrow;
        Intrinsics.checkNotNull((Object)exception);
        $listener.onFailure(Companion.unwrapSecurityExceptionIfPresent(exception));
    }

    private static final void doExecute$lambda$6(String $followerClusterName, SetupChecksRequest $request, TransportSetupChecksAction this$0, Ref.ObjectRef $leaderClusterClient, StepListener $userPermissionsValidationAtRemote, AcknowledgedResponse it) {
        log.info("Permissions validation successful for User [local:" + $followerClusterName + ", resource:" + $request.getFollowerContext().getResource() + "]");
        Object object = $leaderClusterClient.element;
        Intrinsics.checkNotNull((Object)object);
        this$0.triggerPermissionsValidation((Client)object, $request.getConnectionName(), $request.getLeaderContext(), false, (ActionListener<AcknowledgedResponse>)((ActionListener)$userPermissionsValidationAtRemote));
    }

    private static final void doExecute$lambda$7(String $followerClusterName, SetupChecksRequest $request, ActionListener $listener, Exception e) {
        String string = $request.getFollowerContext().getResource();
        Intrinsics.checkNotNull((Object)e);
        log.error("Permissions validation failed for User [local:" + $followerClusterName + ", resource:" + string + "] with " + ExtensionsKt.stackTraceToString(e));
        $listener.onFailure(Companion.unwrapSecurityExceptionIfPresent(e));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\tR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/replication/action/setup/TransportSetupChecksAction$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "unwrapSecurityExceptionIfPresent", "Ljava/lang/Exception;", "Lkotlin/Exception;", "e", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Exception unwrapSecurityExceptionIfPresent(@NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Optional ex = ExceptionsHelper.unwrapCausesAndSuppressed((Throwable)e, Companion::unwrapSecurityExceptionIfPresent$lambda$0);
            if (!ex.isPresent()) {
                return e;
            }
            Object t = ex.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            Exception securityException = (Exception)t;
            return (Exception)new OpenSearchSecurityException(securityException.getMessage(), RestStatus.FORBIDDEN, securityException.getCause(), new Object[0]);
        }

        private static final boolean unwrapSecurityExceptionIfPresent$lambda$0(Throwable cause) {
            return cause instanceof OpenSearchSecurityException;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

