"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@osd/config-schema");
var _constants = require("./common/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  enabledFileTypes: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: [_constants.CSV_FILE_TYPE, _constants.JSON_FILE_TYPE, _constants.NDJSON_FILE_TYPE]
  }),
  maxFileSizeBytes: _configSchema.schema.number({
    defaultValue: 100000000,
    min: 1
  }),
  maxTextCount: _configSchema.schema.number({
    defaultValue: 10000,
    min: 1
  }),
  filePreviewDocumentsCount: _configSchema.schema.number({
    defaultValue: 10,
    min: 1
  })
});