"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PPL_TOKEN_SETS = exports.ID = void 0;
exports.ID = 'PPL';
/**
 * PPL token type lookup table organized by Monaco editor token class
 * Maps Monaco token types to Sets of ANTLR token types for O(1) lookup performance
 */
exports.PPL_TOKEN_SETS = {
    keyword: new Set([
        'SEARCH',
        'DESCRIBE',
        'SHOW',
        'EXPLAIN',
        'FROM',
        'WHERE',
        'FIELDS',
        'FIELD',
        'TABLE',
        'RENAME',
        'STATS',
        'EVENTSTATS',
        'DEDUP',
        'SORT',
        'EVAL',
        'HEAD',
        'BIN',
        'TOP',
        'RARE',
        'PARSE',
        'SPATH',
        'REGEX',
        'REX',
        'SED',
        'PUNCT',
        'GROK',
        'PATTERN',
        'PATTERNS',
        'NEW_FIELD',
        'KMEANS',
        'AD',
        'ML',
        'FILLNULL',
        'FLATTEN',
        'TRENDLINE',
        'TIMECHART',
        'APPENDCOL',
        'EXPAND',
        'SIMPLE_PATTERN',
        'BRAIN',
        'JOIN',
        'METHOD',
        'SOURCE',
        'NOT',
        'OR',
        'AND',
        'XOR',
        'TRUE',
        'FALSE',
        'REGEXP',
        'REGEX_MATCH',
        'CASE',
        'ELSE',
        'IN',
        'EXISTS',
    ]),
    attribute: new Set([
        'AS',
        'BY',
        'ON',
        'INNER',
        'OUTER',
        'FULL',
        'SEMI',
        'ANTI',
        'CROSS',
        'LEFT_HINT',
        'RIGHT_HINT',
        'INDEX',
        'A',
        'ASC',
        'D',
        'DESC',
        'DATASOURCES',
        'USING',
        'WITH',
        'SIMPLE',
        'STANDARD',
        'COST',
        'EXTENDED',
        'OVERRIDE',
        'OVERWRITE',
        'SORTBY',
        'KEEPEMPTY',
        'CONSECUTIVE',
        'DEDUP_SPLITVALUES',
        'PARTITIONS',
        'ALLNUM',
        'DELIM',
        'BUCKET_NULLABLE',
        'CENTROIDS',
        'ITERATIONS',
        'DISTANCE_TYPE',
        'NUMBER_OF_TREES',
        'SHINGLE_SIZE',
        'SAMPLE_SIZE',
        'OUTPUT_AFTER',
        'TIME_DECAY',
        'ANOMALY_RATE',
        'CATEGORY_FIELD',
        'TIME_FIELD',
        'TIME_ZONE',
        'TRAINING_DATA_SIZE',
        'ANOMALY_SCORE_THRESHOLD',
        'APPEND',
        'COUNTFIELD',
        'SHOWCOUNT',
        'LIMIT',
        'USEOTHER',
        'INPUT',
        'OUTPUT',
        'PATH',
        'VARIABLE_COUNT_THRESHOLD',
        'FREQUENCY_THRESHOLD_PERCENTAGE',
        'MAX_SAMPLE_COUNT',
        'MAX_MATCH',
        'OFFSET_FIELD',
        'BUFFER_LIMIT',
        'LABEL',
        'AGGREGATION',
        'SMA',
        'WMA',
        'BINS',
        'MINSPAN',
        'START',
        'END',
        'ALIGNTIME',
        'ALLOW_LEADING_WILDCARD',
        'ANALYZE_WILDCARD',
        'ANALYZER',
        'AUTO_GENERATE_SYNONYMS_PHRASE_QUERY',
        'BOOST',
        'CUTOFF_FREQUENCY',
        'DEFAULT_FIELD',
        'DEFAULT_OPERATOR',
        'ENABLE_POSITION_INCREMENTS',
        'ESCAPE',
        'FLAGS',
        'FUZZY_MAX_EXPANSIONS',
        'FUZZY_PREFIX_LENGTH',
        'FUZZY_TRANSPOSITIONS',
        'FUZZY_REWRITE',
        'FUZZINESS',
        'LENIENT',
        'LOW_FREQ_OPERATOR',
        'MAX_DETERMINIZED_STATES',
        'MAX_EXPANSIONS',
        'MINIMUM_SHOULD_MATCH',
        'OPERATOR',
        'PHRASE_SLOP',
        'PREFIX_LENGTH',
        'QUOTE_ANALYZER',
        'QUOTE_FIELD_SUFFIX',
        'REWRITE',
        'SLOP',
        'TIE_BREAKER',
        'TYPE',
        'ZERO_TERMS_QUERY',
    ]),
    type: new Set([
        'AUTO',
        'STR',
        'IP',
        'NUM',
        'INT',
        'INTEGER',
        'DOUBLE',
        'LONG',
        'FLOAT',
        'STRING',
        'BOOLEAN',
        'MS',
        'S',
        'M',
        'H',
        'W',
        'Q',
        'Y',
        'SEC',
        'SECS',
        'SECONDS',
        'MINS',
        'MINUTES',
        'HR',
        'HRS',
        'HOURS',
        'DAYS',
        'MON',
        'MONTHS',
        'US',
        'CS',
        'DS',
        'CONVERT_TZ',
        'DATETIME',
        'DAY',
        'DAY_HOUR',
        'DAY_MICROSECOND',
        'DAY_MINUTE',
        'DAY_OF_YEAR',
        'DAY_SECOND',
        'HOUR',
        'HOUR_MICROSECOND',
        'HOUR_MINUTE',
        'HOUR_OF_DAY',
        'HOUR_SECOND',
        'INTERVAL',
        'MICROSECOND',
        'MILLISECOND',
        'MINUTE',
        'MINUTE_MICROSECOND',
        'MINUTE_OF_DAY',
        'MINUTE_OF_HOUR',
        'MINUTE_SECOND',
        'MONTH',
        'MONTH_OF_YEAR',
        'QUARTER',
        'SECOND',
        'SECOND_MICROSECOND',
        'SECOND_OF_MINUTE',
        'WEEK',
        'WEEK_OF_YEAR',
        'YEAR',
        'YEAR_MONTH',
    ]),
    tag: new Set(['DATAMODEL', 'LOOKUP', 'SAVEDSEARCH']),
    'predefined.function': new Set([
        'AVG',
        'COUNT',
        'DISTINCT_COUNT',
        'DISTINCT_COUNT_APPROX',
        'ESTDC',
        'ESTDC_ERROR',
        'MAX',
        'MEAN',
        'MEDIAN',
        'MIN',
        'MODE',
        'RANGE',
        'STDEV',
        'STDEVP',
        'SUM',
        'SUMSQ',
        'VAR_SAMP',
        'VAR_POP',
        'STDDEV_SAMP',
        'STDDEV_POP',
        'PERC',
        'PERCENTILE',
        'PERCENTILE_APPROX',
        'TAKE',
        'FIRST',
        'LAST',
        'NTH',
        'NTILE',
        'LIST',
        'VALUES',
        'EARLIEST',
        'EARLIEST_TIME',
        'LATEST',
        'LATEST_TIME',
        'PER_DAY',
        'PER_HOUR',
        'PER_MINUTE',
        'PER_SECOND',
        'RATE',
        'SPARKLINE',
        'C',
        'DC',
        'ROW_NUMBER',
        'RANK',
        'DENSE_RANK',
        'PERCENT_RANK',
        'CUME_DIST',
        'ABS',
        'CBRT',
        'CEIL',
        'CEILING',
        'CONV',
        'CRC32',
        'E',
        'EXP',
        'EXPM1',
        'FLOOR',
        'LN',
        'LOG',
        'LOG10',
        'LOG2',
        'MOD',
        'MODULUS',
        'PI',
        'POSITION',
        'POW',
        'POWER',
        'RAND',
        'ROUND',
        'SIGN',
        'SQRT',
        'TRUNCATE',
        'RINT',
        'SIGNUM',
        'ACOS',
        'ASIN',
        'ATAN',
        'ATAN2',
        'COS',
        'COSH',
        'COT',
        'DEGREES',
        'RADIANS',
        'SIN',
        'SINH',
        'TAN',
        'MD5',
        'SHA1',
        'SHA2',
        'GEOIP',
        'ARRAY',
        'ARRAY_LENGTH',
        'MVJOIN',
        'FORALL',
        'FILTER',
        'TRANSFORM',
        'REDUCE',
        'JSON_VALID',
        'JSON',
        'JSON_OBJECT',
        'JSON_ARRAY',
        'JSON_ARRAY_LENGTH',
        'JSON_EXTRACT',
        'JSON_KEYS',
        'JSON_SET',
        'JSON_DELETE',
        'JSON_APPEND',
        'JSON_EXTEND',
        'COALESCE',
        'CIDRMATCH',
        'BETWEEN',
        'ISPRESENT',
        'ISEMPTY',
        'ISBLANK',
        'SPAN',
        'MATCH',
        'MATCH_PHRASE',
        'MATCH_PHRASE_PREFIX',
        'MATCH_BOOL_PREFIX',
    ]),
    predefined: new Set([
        'ADDDATE',
        'ADDTIME',
        'CURDATE',
        'CURRENT_DATE',
        'CURRENT_TIME',
        'CURRENT_TIMESTAMP',
        'CURTIME',
        'DATE',
        'DATEDIFF',
        'DATE_ADD',
        'DATE_FORMAT',
        'DATE_SUB',
        'DAYNAME',
        'DAYOFMONTH',
        'DAYOFWEEK',
        'DAYOFYEAR',
        'DAY_OF_MONTH',
        'DAY_OF_WEEK',
        'EXTRACT',
        'FROM_DAYS',
        'FROM_UNIXTIME',
        'GET_FORMAT',
        'LAST_DAY',
        'LOCALTIME',
        'LOCALTIMESTAMP',
        'MAKEDATE',
        'MAKETIME',
        'MONTHNAME',
        'NOW',
        'PERIOD_ADD',
        'PERIOD_DIFF',
        'SEC_TO_TIME',
        'STR_TO_DATE',
        'SUBDATE',
        'SUBTIME',
        'SYSDATE',
        'TIME',
        'TIMEDIFF',
        'TIMESTAMP',
        'TIMESTAMPADD',
        'TIMESTAMPDIFF',
        'TIME_FORMAT',
        'TIME_TO_SEC',
        'TO_DAYS',
        'TO_SECONDS',
        'UNIX_TIMESTAMP',
        'UTC_DATE',
        'UTC_TIME',
        'UTC_TIMESTAMP',
        'WEEKDAY',
        'YEARWEEK',
        'STRFTIME',
        'SUBSTR',
        'SUBSTRING',
        'LTRIM',
        'RTRIM',
        'TRIM',
        'TO',
        'LOWER',
        'UPPER',
        'CONCAT',
        'CONCAT_WS',
        'LENGTH',
        'STRCMP',
        'RIGHT',
        'LEFT',
        'ASCII',
        'LOCATE',
        'REPLACE',
        'REVERSE',
        'CAST',
        'LIKE',
        'ISNULL',
        'ISNOTNULL',
        'IFNULL',
        'NULLIF',
        'IF',
        'TYPEOF',
        'SIMPLE_QUERY_STRING',
        'MULTI_MATCH',
        'QUERY_STRING',
    ]),
    operator: new Set([
        'PIPE',
        'COMMA',
        'DOT',
        'EQUAL',
        'DOUBLE_EQUAL',
        'GREATER',
        'LESS',
        'NOT_GREATER',
        'NOT_LESS',
        'NOT_EQUAL',
        'PLUS',
        'MINUS',
        'STAR',
        'DIVIDE',
        'MODULE',
        'EXCLAMATION_SYMBOL',
        'COLON',
        'ARROW',
        'BIT_NOT_OP',
        'BIT_AND_OP',
        'BIT_XOR_OP',
    ]),
    delimiter: new Set([
        'LT_PRTHS',
        'RT_PRTHS',
        'LT_SQR_PRTHS',
        'RT_SQR_PRTHS',
        'LT_CURLY',
        'RT_CURLY',
        'SINGLE_QUOTE',
        'DOUBLE_QUOTE',
        'BACKTICK',
    ]),
    variable: new Set(['ID', 'CLUSTER', 'TIMESTAMP', 'BQUOTA_STRING', 'ID_DATE_SUFFIX']),
    string: new Set(['DQUOTA_STRING', 'SQUOTA_STRING']),
    number: new Set(['INTEGER_LITERAL', 'DECIMAL_LITERAL', 'FLOAT_LITERAL', 'DOUBLE_LITERAL']),
    comment: new Set(['COMMENT', 'LINE_COMMENT', 'BLOCK_COMMENT']),
    white: new Set(['SPACE']),
};
//# sourceMappingURL=constants.js.map