/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.CheckableNameNodeResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class NameNodeResourcePolicy {
    private static final Logger LOG = LoggerFactory.getLogger((String)NameNodeResourcePolicy.class.getName());

    NameNodeResourcePolicy() {
    }

    static boolean areResourcesAvailable(Collection<? extends CheckableNameNodeResource> resources, int minimumRedundantResources) {
        boolean areResourceAvailable;
        if (resources.isEmpty()) {
            return true;
        }
        int requiredResourceCount = 0;
        int redundantResourceCount = 0;
        int disabledRedundantResourceCount = 0;
        for (CheckableNameNodeResource checkableNameNodeResource : resources) {
            if (!checkableNameNodeResource.isRequired()) {
                ++redundantResourceCount;
                if (checkableNameNodeResource.isResourceAvailable()) continue;
                ++disabledRedundantResourceCount;
                continue;
            }
            ++requiredResourceCount;
            if (checkableNameNodeResource.isResourceAvailable()) continue;
            return false;
        }
        if (redundantResourceCount == 0) {
            return requiredResourceCount > 0;
        }
        boolean bl = areResourceAvailable = redundantResourceCount - disabledRedundantResourceCount >= minimumRedundantResources;
        if (!areResourceAvailable) {
            LOG.info("Resources not available. Details: redundantResourceCount={}, disabledRedundantResourceCount={}, minimumRedundantResources={}.", new Object[]{redundantResourceCount, disabledRedundantResourceCount, minimumRedundantResources});
        }
        return areResourceAvailable;
    }
}

