/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control;

import java.nio.ByteBuffer;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.AbstractParseHandler;
import org.ldaptive.asn1.ConstructedDEREncoder;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.DERPath;
import org.ldaptive.asn1.IntegerType;
import org.ldaptive.asn1.OctetStringType;
import org.ldaptive.asn1.ParseHandler;
import org.ldaptive.asn1.UniversalDERTag;
import org.ldaptive.control.AbstractControl;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.ResponseControl;

public class PagedResultsControl
extends AbstractControl
implements RequestControl,
ResponseControl {
    public static final String OID = "1.2.840.113556.1.4.319";
    private static final int HASH_CODE_SEED = 709;
    private static final byte[] EMPTY_COOKIE = new byte[0];
    private int resultSize;
    private byte[] cookie;

    public PagedResultsControl() {
        super(OID);
    }

    public PagedResultsControl(boolean critical) {
        super(OID, critical);
    }

    public PagedResultsControl(int size) {
        super(OID);
        this.setSize(size);
    }

    public PagedResultsControl(int size, boolean critical) {
        super(OID, critical);
        this.setSize(size);
    }

    public PagedResultsControl(int size, byte[] value, boolean critical) {
        super(OID, critical);
        this.setSize(size);
        this.setCookie(value);
    }

    public int getSize() {
        return this.resultSize;
    }

    public void setSize(int size) {
        this.resultSize = size;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] value) {
        this.cookie = value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PagedResultsControl && super.equals(o)) {
            PagedResultsControl v = (PagedResultsControl)o;
            return LdapUtils.areEqual(this.resultSize, v.resultSize) && LdapUtils.areEqual(this.cookie, v.cookie);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(709, this.getOID(), this.getCriticality(), this.resultSize, this.cookie);
    }

    public String toString() {
        return String.format("[%s@%d::criticality=%s, size=%s, cookie=%s]", this.getClass().getName(), this.hashCode(), this.getCriticality(), this.resultSize, LdapUtils.base64Encode(this.cookie));
    }

    @Override
    public byte[] encode() {
        ConstructedDEREncoder se = new ConstructedDEREncoder(UniversalDERTag.SEQ, new IntegerType(this.getSize()), new OctetStringType(this.getCookie() != null ? this.getCookie() : EMPTY_COOKIE));
        return se.encode();
    }

    @Override
    public void decode(byte[] berValue) {
        this.logger.trace("decoding control: {}", (Object)LdapUtils.base64Encode(berValue));
        DERParser parser = new DERParser();
        parser.registerHandler(SizeHandler.PATH, (ParseHandler)new SizeHandler(this));
        parser.registerHandler(CookieHandler.PATH, (ParseHandler)new CookieHandler(this));
        parser.parse(ByteBuffer.wrap(berValue));
    }

    private static class CookieHandler
    extends AbstractParseHandler<PagedResultsControl> {
        public static final DERPath PATH = new DERPath("/SEQ/OCTSTR");

        CookieHandler(PagedResultsControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            byte[] cookie = OctetStringType.readBuffer(encoded);
            if (cookie != null && cookie.length > 0) {
                ((PagedResultsControl)this.getObject()).setCookie(cookie);
            }
        }
    }

    private static class SizeHandler
    extends AbstractParseHandler<PagedResultsControl> {
        public static final DERPath PATH = new DERPath("/SEQ/INT");

        SizeHandler(PagedResultsControl control) {
            super(control);
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((PagedResultsControl)this.getObject()).setSize(IntegerType.decode(encoded).intValue());
        }
    }
}

