#!/usr/bin/python

# ----------------------------------------------------------------------------
#
#  Copyright (C) 2023 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


import sys
import signal
import globdef
from PyQt6 import QtWidgets
from zita_jacktools.jackbw8filt import *
from mainwin import Mainwindow


# Create the filter.
#
nchannel = 1
jackname = 'Bandpass'
jackfilt = JackBW8filt (nchannel, nchannel, jackname)

# Connect inputs and outputs.
#
#jmat.connect_input (0, '...')
#jmat.connect_input (1, '...')
#
#jmat.connect_output (0, '...')
#jmat.connect_output (1, '...')


# Start PyQt6 app.
#
signal.signal (signal.SIGINT, signal.SIG_DFL)
app = QtWidgets.QApplication (sys.argv)
# Comment next line for default light theme.
globdef.darkpal (app)
mainwin = Mainwindow (nchannel, jackfilt, jackname)
sys.exit (app.exec())


