/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.LongConversionBaseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.LongIndexConverterNodeGen;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class LongIndexConverterNode
extends LongConversionBaseNode {
    protected LongIndexConverterNode(long defaultValue, boolean useDefaultForNone) {
        super(defaultValue, useDefaultForNone);
    }

    @Specialization(guards={"!isHandledPNone(value)"})
    static long doOthers(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached CastToJavaLongExactNode cast) {
        return cast.execute(inliningTarget, indexNode.execute((Frame)frame, inliningTarget, value));
    }

    @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int, ArgumentClinic.PrimitiveType.Long})
    @NeverDefault
    public static LongIndexConverterNode create(@ClinicConverterFactory.DefaultValue long defaultValue, @ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        return LongIndexConverterNodeGen.create(defaultValue, useDefaultForNone);
    }

    @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int, ArgumentClinic.PrimitiveType.Long})
    @NeverDefault
    public static LongIndexConverterNode create(@ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        assert (!useDefaultForNone) : "defaultValue must be provided if useDefaultForNone is true";
        return LongIndexConverterNodeGen.create(0L, false);
    }

    @NeverDefault
    public static LongIndexConverterNode create() {
        return LongIndexConverterNode.create(false);
    }
}

