; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; Test 32-bit atomic minimum and maximum.  Here we match the z10 versions,
; which can't use LOCR.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z10 | FileCheck %s

; Todo: If-converter no longer producing CondReturns (with AtomicExpand pass).

; Check signed minimum.
define i32 @f1(i32 %dummy, ptr %src, i32 %b) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r2, 0(%r3)
; CHECK-NEXT:    j .LBB0_2
; CHECK-NEXT:  .LBB0_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB0_2 Depth=1
; CHECK-NEXT:    cs %r2, %r0, 0(%r3)
; CHECK-NEXT:    je .LBB0_4
; CHECK-NEXT:  .LBB0_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    crjle %r2, %r4, .LBB0_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB0_2 Depth=1
; CHECK-NEXT:    lr %r0, %r4
; CHECK-NEXT:    j .LBB0_1
; CHECK-NEXT:  .LBB0_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %res = atomicrmw min ptr %src, i32 %b seq_cst
  ret i32 %res
}

; Check signed maximum.
define i32 @f2(i32 %dummy, ptr %src, i32 %b) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r2, 0(%r3)
; CHECK-NEXT:    j .LBB1_2
; CHECK-NEXT:  .LBB1_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB1_2 Depth=1
; CHECK-NEXT:    cs %r2, %r0, 0(%r3)
; CHECK-NEXT:    je .LBB1_4
; CHECK-NEXT:  .LBB1_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    crjh %r2, %r4, .LBB1_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB1_2 Depth=1
; CHECK-NEXT:    lr %r0, %r4
; CHECK-NEXT:    j .LBB1_1
; CHECK-NEXT:  .LBB1_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %res = atomicrmw max ptr %src, i32 %b seq_cst
  ret i32 %res
}

; Check unsigned minimum.
define i32 @f3(i32 %dummy, ptr %src, i32 %b) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r2, 0(%r3)
; CHECK-NEXT:    j .LBB2_2
; CHECK-NEXT:  .LBB2_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB2_2 Depth=1
; CHECK-NEXT:    cs %r2, %r0, 0(%r3)
; CHECK-NEXT:    je .LBB2_4
; CHECK-NEXT:  .LBB2_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    clrjle %r2, %r4, .LBB2_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB2_2 Depth=1
; CHECK-NEXT:    lr %r0, %r4
; CHECK-NEXT:    j .LBB2_1
; CHECK-NEXT:  .LBB2_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %res = atomicrmw umin ptr %src, i32 %b seq_cst
  ret i32 %res
}

; Check unsigned maximum.
define i32 @f4(i32 %dummy, ptr %src, i32 %b) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r2, 0(%r3)
; CHECK-NEXT:    j .LBB3_2
; CHECK-NEXT:  .LBB3_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB3_2 Depth=1
; CHECK-NEXT:    cs %r2, %r0, 0(%r3)
; CHECK-NEXT:    je .LBB3_4
; CHECK-NEXT:  .LBB3_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    clrjh %r2, %r4, .LBB3_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB3_2 Depth=1
; CHECK-NEXT:    lr %r0, %r4
; CHECK-NEXT:    j .LBB3_1
; CHECK-NEXT:  .LBB3_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %res = atomicrmw umax ptr %src, i32 %b seq_cst
  ret i32 %res
}

; Check the high end of the aligned CS range.
define i32 @f5(i32 %dummy, ptr %src, i32 %b) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r2, 4092(%r3)
; CHECK-NEXT:    j .LBB4_2
; CHECK-NEXT:  .LBB4_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB4_2 Depth=1
; CHECK-NEXT:    cs %r2, %r0, 4092(%r3)
; CHECK-NEXT:    je .LBB4_4
; CHECK-NEXT:  .LBB4_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    crjle %r2, %r4, .LBB4_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB4_2 Depth=1
; CHECK-NEXT:    lr %r0, %r4
; CHECK-NEXT:    j .LBB4_1
; CHECK-NEXT:  .LBB4_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i32, ptr %src, i64 1023
  %res = atomicrmw min ptr %ptr, i32 %b seq_cst
  ret i32 %res
}

; Check the next word up, which requires CSY.
define i32 @f6(i32 %dummy, ptr %src, i32 %b) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ly %r2, 4096(%r3)
; CHECK-NEXT:    j .LBB5_2
; CHECK-NEXT:  .LBB5_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB5_2 Depth=1
; CHECK-NEXT:    csy %r2, %r0, 4096(%r3)
; CHECK-NEXT:    je .LBB5_4
; CHECK-NEXT:  .LBB5_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    crjle %r2, %r4, .LBB5_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB5_2 Depth=1
; CHECK-NEXT:    lr %r0, %r4
; CHECK-NEXT:    j .LBB5_1
; CHECK-NEXT:  .LBB5_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i32, ptr %src, i64 1024
  %res = atomicrmw min ptr %ptr, i32 %b seq_cst
  ret i32 %res
}

; Check the high end of the aligned CSY range.
define i32 @f7(i32 %dummy, ptr %src, i32 %b) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ly %r2, 524284(%r3)
; CHECK-NEXT:    j .LBB6_2
; CHECK-NEXT:  .LBB6_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB6_2 Depth=1
; CHECK-NEXT:    csy %r2, %r0, 524284(%r3)
; CHECK-NEXT:    je .LBB6_4
; CHECK-NEXT:  .LBB6_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    crjle %r2, %r4, .LBB6_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB6_2 Depth=1
; CHECK-NEXT:    lr %r0, %r4
; CHECK-NEXT:    j .LBB6_1
; CHECK-NEXT:  .LBB6_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i32, ptr %src, i64 131071
  %res = atomicrmw min ptr %ptr, i32 %b seq_cst
  ret i32 %res
}

; Check the next word up, which needs separate address logic.
define i32 @f8(i32 %dummy, ptr %src, i32 %b) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    agfi %r3, 524288
; CHECK-NEXT:    l %r2, 0(%r3)
; CHECK-NEXT:    j .LBB7_2
; CHECK-NEXT:  .LBB7_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB7_2 Depth=1
; CHECK-NEXT:    cs %r2, %r0, 0(%r3)
; CHECK-NEXT:    je .LBB7_4
; CHECK-NEXT:  .LBB7_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    crjle %r2, %r4, .LBB7_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB7_2 Depth=1
; CHECK-NEXT:    lr %r0, %r4
; CHECK-NEXT:    j .LBB7_1
; CHECK-NEXT:  .LBB7_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i32, ptr %src, i64 131072
  %res = atomicrmw min ptr %ptr, i32 %b seq_cst
  ret i32 %res
}

; Check the high end of the negative aligned CSY range.
define i32 @f9(i32 %dummy, ptr %src, i32 %b) {
; CHECK-LABEL: f9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ly %r2, -4(%r3)
; CHECK-NEXT:    j .LBB8_2
; CHECK-NEXT:  .LBB8_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB8_2 Depth=1
; CHECK-NEXT:    csy %r2, %r0, -4(%r3)
; CHECK-NEXT:    je .LBB8_4
; CHECK-NEXT:  .LBB8_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    crjle %r2, %r4, .LBB8_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB8_2 Depth=1
; CHECK-NEXT:    lr %r0, %r4
; CHECK-NEXT:    j .LBB8_1
; CHECK-NEXT:  .LBB8_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i32, ptr %src, i64 -1
  %res = atomicrmw min ptr %ptr, i32 %b seq_cst
  ret i32 %res
}

; Check the low end of the CSY range.
define i32 @f10(i32 %dummy, ptr %src, i32 %b) {
; CHECK-LABEL: f10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ly %r2, -524288(%r3)
; CHECK-NEXT:    j .LBB9_2
; CHECK-NEXT:  .LBB9_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB9_2 Depth=1
; CHECK-NEXT:    csy %r2, %r0, -524288(%r3)
; CHECK-NEXT:    je .LBB9_4
; CHECK-NEXT:  .LBB9_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    crjle %r2, %r4, .LBB9_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB9_2 Depth=1
; CHECK-NEXT:    lr %r0, %r4
; CHECK-NEXT:    j .LBB9_1
; CHECK-NEXT:  .LBB9_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i32, ptr %src, i64 -131072
  %res = atomicrmw min ptr %ptr, i32 %b seq_cst
  ret i32 %res
}

; Check the next word down, which needs separate address logic.
define i32 @f11(i32 %dummy, ptr %src, i32 %b) {
; CHECK-LABEL: f11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    agfi %r3, -524292
; CHECK-NEXT:    l %r2, 0(%r3)
; CHECK-NEXT:    j .LBB10_2
; CHECK-NEXT:  .LBB10_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB10_2 Depth=1
; CHECK-NEXT:    cs %r2, %r0, 0(%r3)
; CHECK-NEXT:    je .LBB10_4
; CHECK-NEXT:  .LBB10_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    crjle %r2, %r4, .LBB10_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB10_2 Depth=1
; CHECK-NEXT:    lr %r0, %r4
; CHECK-NEXT:    j .LBB10_1
; CHECK-NEXT:  .LBB10_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i32, ptr %src, i64 -131073
  %res = atomicrmw min ptr %ptr, i32 %b seq_cst
  ret i32 %res
}

; Check that indexed addresses are not allowed.
define i32 @f12(i32 %dummy, i64 %base, i64 %index, i32 %b) {
; CHECK-LABEL: f12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r2, 0(%r4,%r3)
; CHECK-NEXT:    agr %r3, %r4
; CHECK-NEXT:    j .LBB11_2
; CHECK-NEXT:  .LBB11_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB11_2 Depth=1
; CHECK-NEXT:    cs %r2, %r0, 0(%r3)
; CHECK-NEXT:    je .LBB11_4
; CHECK-NEXT:  .LBB11_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    crjle %r2, %r5, .LBB11_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB11_2 Depth=1
; CHECK-NEXT:    lr %r0, %r5
; CHECK-NEXT:    j .LBB11_1
; CHECK-NEXT:  .LBB11_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %add = add i64 %base, %index
  %ptr = inttoptr i64 %add to ptr
  %res = atomicrmw min ptr %ptr, i32 %b seq_cst
  ret i32 %res
}

; Check that constants are handled.
define i32 @f13(i32 %dummy, ptr %ptr) {
; CHECK-LABEL: f13:
; CHECK:       # %bb.0:
; CHECK-NEXT:    l %r2, 0(%r3)
; CHECK-NEXT:    j .LBB12_2
; CHECK-NEXT:  .LBB12_1: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB12_2 Depth=1
; CHECK-NEXT:    cs %r2, %r0, 0(%r3)
; CHECK-NEXT:    je .LBB12_4
; CHECK-NEXT:  .LBB12_2: # %atomicrmw.start
; CHECK-NEXT:    # =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    lr %r0, %r2
; CHECK-NEXT:    cijl %r2, 43, .LBB12_1
; CHECK-NEXT:  # %bb.3: # %atomicrmw.start
; CHECK-NEXT:    # in Loop: Header=BB12_2 Depth=1
; CHECK-NEXT:    lhi %r0, 42
; CHECK-NEXT:    j .LBB12_1
; CHECK-NEXT:  .LBB12_4: # %atomicrmw.end
; CHECK-NEXT:    br %r14
  %res = atomicrmw min ptr %ptr, i32 42 seq_cst
  ret i32 %res
}
