/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_BOOTCONFIGSETTINGDATAACCESS_H_
#define OPENDRIM_BOOTCONFIGSETTINGDATAACCESS_H_

#include "Boot_Common.h"

#include "OpenDRIM_BootConfigSettingData.h"
#include "assocOpenDRIM_BootConfigSettingData.h"

int Boot_OpenDRIM_BootConfigSettingData_load(const CMPIBroker* broker, string& errorMessage);

int Boot_OpenDRIM_BootConfigSettingData_unload(string& errorMessage);

int Boot_OpenDRIM_BootConfigSettingData_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootConfigSettingData>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootConfigSettingData_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootConfigSettingData& instance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootConfigSettingData_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSettingData& newInstance, const OpenDRIM_BootConfigSettingData& oldInstance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootConfigSettingData_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSettingData& instance, string& errorMessage);

int Boot_OpenDRIM_BootConfigSettingData_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSettingData& instance, string& errorMessage);

int Boot_OpenDRIM_BootConfigSettingData_associatorSettingDataToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SettingData_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootConfigSettingData_associatorManagedElementToSettingData(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& SettingData_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootConfigSettingData_referenceSettingDataToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SettingData_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_BootConfigSettingData>& OpenDRIM_BootConfigSettingData_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootConfigSettingData_referenceManagedElementToSettingData(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& SettingData_instances, vector<OpenDRIM_BootConfigSettingData>& OpenDRIM_BootConfigSettingData_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootConfigSettingData_populate(OpenDRIM_BootConfigSettingData& instance, const Instance& SettingData_instance, string& errorMessage);

#endif /*OPENDRIM_BOOTCONFIGSETTINGDATAACCESS_H_*/
