/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_ServiceAffectsBootAccess.h"

int Boot_OpenDRIM_ServiceAffectsBoot_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Boot_CIM_ManagedElement_load(broker, errorMessage));
	CF_assert(Boot_CIM_Service_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Boot_OpenDRIM_ServiceAffectsBoot_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Boot_CIM_ManagedElement_unload(errorMessage));
	CF_assert(Boot_CIM_Service_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Boot_OpenDRIM_ServiceAffectsBoot_isAssociated(const Instance& AffectedElement, const Instance& AffectingElement, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int Boot_OpenDRIM_ServiceAffectsBoot_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ServiceAffectsBoot>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_enumerateAffectedElements(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_enumerateAffectedElements(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		Boot_OpenDRIM_ServiceAffectsBoot_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			AffectedElement_classnames[0], AffectingElement_classnames[0],
			AffectedElement_role.c_str(), AffectingElement_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_referenceAffectedElementToAffectingElement(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_ServiceAffectsBoot_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ServiceAffectsBoot& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath AffectedElement_objectpath;
	instance.getAffectedElement(AffectedElement_objectpath);
	Instance AffectedElement_instance;
	CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_getAffectedElement(broker, ctx, AffectedElement_objectpath, AffectedElement_instance, NULL, errorMessage));
	
	Objectpath AffectingElement_objectpath;
	instance.getAffectingElement(AffectingElement_objectpath);
	Instance AffectingElement_instance;
	CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_getAffectingElement(broker, ctx, AffectingElement_objectpath, AffectingElement_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_isAssociated(AffectedElement_instance, AffectingElement_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_populate(instance, errorMessage));
	_L_;
	return OK;
}

int Boot_OpenDRIM_ServiceAffectsBoot_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsBoot& newInstance, const OpenDRIM_ServiceAffectsBoot& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_ServiceAffectsBoot_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsBoot& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_ServiceAffectsBoot_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsBoot& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_ServiceAffectsBoot_associatorAffectedElementToAffectingElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectedElement_instance, const char** properties, vector<Instance>& AffectingElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> AffectingElement_instances;
	if (discriminant=="a")
		CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_enumerateAffectingElements(broker, ctx, AffectingElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_enumerateAffectingElements(broker, ctx, AffectingElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_enumerateAffectingElements(broker, ctx, AffectingElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<AffectingElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_isAssociated(AffectedElement_instance, AffectingElement_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			AffectingElement_associatedInstances.push_back(AffectingElement_instances[i]);
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_ServiceAffectsBoot_associatorAffectingElementToAffectedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectingElement_instance, const char** properties, vector<Instance>& AffectedElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> AffectedElement_instances;
	if (discriminant=="a")
		CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_enumerateAffectedElements(broker, ctx, AffectedElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_enumerateAffectedElements(broker, ctx, AffectedElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_enumerateAffectedElements(broker, ctx, AffectedElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<AffectedElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_isAssociated(AffectedElement_instances[i], AffectingElement_instance, isAssociated, errorMessage));
		if (isAssociated)
			AffectedElement_associatedInstances.push_back(AffectedElement_instances[i]);
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_ServiceAffectsBoot_referenceAffectedElementToAffectingElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectedElement_instance, const vector<Instance>& AffectingElement_instances, vector<OpenDRIM_ServiceAffectsBoot>& OpenDRIM_ServiceAffectsBoot_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < AffectingElement_instances.size(); i++) {
		OpenDRIM_ServiceAffectsBoot instance;
		instance.setAffectedElement(((Instance) AffectedElement_instance).getObjectpath());
		instance.setAffectingElement(((Instance) AffectingElement_instances[i]).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_populate(instance, errorMessage));
		}
		
		OpenDRIM_ServiceAffectsBoot_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_ServiceAffectsBoot_referenceAffectingElementToAffectedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectingElement_instance, const vector<Instance>& AffectedElement_instances, vector<OpenDRIM_ServiceAffectsBoot>& OpenDRIM_ServiceAffectsBoot_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < AffectedElement_instances.size(); i++) {
		OpenDRIM_ServiceAffectsBoot instance;
		instance.setAffectedElement(((Instance) AffectedElement_instances[i]).getObjectpath());
		instance.setAffectingElement(((Instance) AffectingElement_instance).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(Boot_OpenDRIM_ServiceAffectsBoot_populate(instance, errorMessage));
		}
		
		OpenDRIM_ServiceAffectsBoot_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Boot_OpenDRIM_ServiceAffectsBoot_populate(OpenDRIM_ServiceAffectsBoot& instance, string& errorMessage) {
	_E_;
	vector<unsigned short> elementEffects;
	elementEffects.push_back(5); // Manages
	instance.setElementEffects(elementEffects);
	_L_;
	return OK;
}

