% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/season.R
\name{seasonaldummy}
\alias{seasonaldummy}
\alias{seasonaldummyf}
\title{Seasonal dummy variables}
\usage{
seasonaldummy(x, h = NULL)

seasonaldummyf(x, h)
}
\arguments{
\item{x}{Seasonal time series: a \code{ts} or a \code{msts} object}

\item{h}{Number of periods ahead to forecast (optional)}
}
\value{
Numerical matrix.
}
\description{
\code{seasonaldummy} returns a matrix of dummy variables suitable for use in
\code{\link[=Arima]{Arima()}}, \code{\link[=auto.arima]{auto.arima()}} or \code{\link[=tslm]{tslm()}}. The last season is omitted and used
as the control.
}
\details{
\code{seasonaldummyf} is deprecated, instead use the \code{h} argument in
\code{seasonaldummy}.

The number of dummy variables is determined from the time series
characteristics of \code{x}. When \code{h} is missing, the length of
\code{x} also determines the number of rows for the matrix returned by
\code{seasonaldummy}. the value of \code{h} determines the number of rows
for the matrix returned by \code{seasonaldummy}, typically used for
forecasting. The values within \code{x} are not used.
}
\examples{

plot(ldeaths)

# Using seasonal dummy variables
month <- seasonaldummy(ldeaths)
deaths.lm <- tslm(ldeaths ~ month)
tsdisplay(residuals(deaths.lm))
ldeaths.fcast <- forecast(
  deaths.lm,
  data.frame(month = I(seasonaldummy(ldeaths, 36)))
)
plot(ldeaths.fcast)

# A simpler approach to seasonal dummy variables
deaths.lm <- tslm(ldeaths ~ season)
ldeaths.fcast <- forecast(deaths.lm, h = 36)
plot(ldeaths.fcast)

}
\seealso{
\code{\link[=fourier]{fourier()}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
