% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks.R
\name{make.blocks}
\alias{make.blocks}
\title{Creates a \code{blocks} argument}
\usage{
make.blocks(x, partition = c("scatter", "collect", "void"))
}
\arguments{
\item{x}{A \code{data.frame}, character vector with
variable names, or \code{list} with variable names.}

\item{partition}{A character vector of length 1 used to assign
variables to blocks when \code{data} is a \code{data.frame}. Value
\code{"scatter"} (default) assigns each variable to it own
block. Value \code{"collect"} assigns all variables to a single block.}
}
\value{
A named list of character vectors with variables names.
}
\description{
The \code{make.blocks()} helper function generates a suitable
\code{blocks} argument for the \code{[=mice]{mice}} function.
}
\details{
Choices \code{"scatter"} and \code{"collect"} represent to two
extreme scenarios for assigning variables to imputation blocks.
Use \code{"scatter"} to create an imputation model based on
\emph{fully conditionally specification} (FCS). Use \code{"collect"} to
gather all variables to be imputed by a \emph{joint model} (JM).
Scenario's in-between these two extremes represent
\emph{hybrid} imputation models that combine FCS and JM.

Any variable not listed in will not be imputed.
Specification \code{"void"} represents the extreme scenario that
skips imputation of all variables.

A variable may be a member of multiple blocks. The variable will be
re-imputed in each block, so the final imputations for variable
will come from the last block that was executed. This scenario
may be useful where the same complete background factors appear in
multiple imputation blocks.

A variable may appear multiple times within a given block. If a univariate
imputation model is applied to such a block, then the variable is
re-imputed each time as it appears in the block.
}
\examples{
make.blocks(nhanes)
make.blocks(c("age", "sex", "edu"))
}
