% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BenchmarkResult_operators.R
\name{getBMRFilteredFeatures}
\alias{getBMRFilteredFeatures}
\title{Extract the feature selection results from a benchmark result.}
\usage{
getBMRFilteredFeatures(
  bmr,
  task.ids = NULL,
  learner.ids = NULL,
  as.df = FALSE,
  drop = FALSE
)
}
\arguments{
\item{bmr}{(\link{BenchmarkResult})\cr
Benchmark result.}

\item{task.ids}{(\code{character(1)})\cr
Restrict result to certain tasks.
Default is all.}

\item{learner.ids}{(\code{character(1)})\cr
Restrict result to certain learners.
Default is all.}

\item{as.df}{(\code{character(1)})\cr
Return one \link{data.frame} as result - or a list of lists of objects?.
Default is \code{FALSE}.}

\item{drop}{(\code{logical(1)})\cr
If drop is \code{FALSE} (the default), a nested list with
the following structure is returned:\cr
\code{res[task.ids][learner.ids]}.\cr
If drop is set to \code{TRUE} it is checked if the list
structure can be simplified.\cr
If only one learner was passed, a list with entries
for each task is returned.\cr
If only one task was passed, the entries are named after
the corresponding learner.\cr
For an experiment with both one task and learner,
the whole list structure is removed.\cr
Note that the name of the
task/learner will be dropped from the return object.}
}
\value{
(\link{list} | \link{data.frame}). See above.
}
\description{
Returns a nested list of characters The first level of nesting is by data set, the second by learner, the third for the benchmark resampling iterations. The list at the lowest level is the list of selected features. If \code{as.df} is \code{TRUE}, a data frame with \dQuote{task.id}, \dQuote{learner.id}, the resample iteration and the selected features is returned.

Note that if more than one feature is selected and a data frame is requested, there will be multiple rows for the same dataset-learner-iteration; one for each selected feature.
}
\seealso{
Other benchmark: 
\code{\link{BenchmarkResult}},
\code{\link{batchmark}()},
\code{\link{benchmark}()},
\code{\link{convertBMRToRankMatrix}()},
\code{\link{friedmanPostHocTestBMR}()},
\code{\link{friedmanTestBMR}()},
\code{\link{generateCritDifferencesData}()},
\code{\link{getBMRAggrPerformances}()},
\code{\link{getBMRFeatSelResults}()},
\code{\link{getBMRLearnerIds}()},
\code{\link{getBMRLearnerShortNames}()},
\code{\link{getBMRLearners}()},
\code{\link{getBMRMeasureIds}()},
\code{\link{getBMRMeasures}()},
\code{\link{getBMRModels}()},
\code{\link{getBMRPerformances}()},
\code{\link{getBMRPredictions}()},
\code{\link{getBMRTaskDescs}()},
\code{\link{getBMRTaskIds}()},
\code{\link{getBMRTuneResults}()},
\code{\link{plotBMRBoxplots}()},
\code{\link{plotBMRRanksAsBarChart}()},
\code{\link{plotBMRSummary}()},
\code{\link{plotCritDifferences}()},
\code{\link{reduceBatchmarkResults}()}
}
\concept{benchmark}
