% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bytes.R
\name{bytes-class}
\alias{bytes-class}
\alias{as_bytes}
\alias{parse_bytes}
\title{Human readable memory sizes}
\usage{
as_bytes(x)

parse_bytes(x)
}
\arguments{
\item{x}{A numeric or character vector. Character representations can use
shorthand sizes (see examples).}
}
\description{
Construct, manipulate and display vectors of byte sizes. These are numeric
vectors, so you can compare them numerically, but they can also be compared
to human readable values such as '10MB'.
\itemize{
\item \code{parse_bytes()} takes a character vector of human-readable bytes
and returns a structured bytes vector.
\item \code{as_bytes()} is a generic conversion function for objects
representing bytes.
}

Note: A \code{bytes()} constructor will be exported soon.
}
\details{
These memory sizes are always assumed to be base 1000, rather than 1024.
}
\examples{
parse_bytes("1")
parse_bytes("1K")
parse_bytes("1Kb")
parse_bytes("1KiB")
parse_bytes("1MB")

parse_bytes("1KB") < "1MB"

sum(parse_bytes(c("1MB", "5MB", "500KB")))
}
