% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegionDefinitions.R
\docType{class}
\name{RegionDefinition-class}
\alias{RegionDefinition-class}
\alias{RegionDefinition}
\title{S4 class defining a region definition}
\description{
\code{RegionDefinition} defines a common data structure for defining the region
boundaries of an Ig sequence.
}
\section{Slots}{

\describe{
\item{\code{name}}{name of the RegionDefinition.}

\item{\code{description}}{description of the model and its source.}

\item{\code{boundaries}}{\code{factor} defining the region boundaries of the 
sequence. The levels and values of \code{boundaries} 
determine the number of regions.}

\item{\code{seqLength}}{length of the sequence.}

\item{\code{regions}}{levels of the boundaries; e.g, \code{c("cdr", "fwr")}.}

\item{\code{labels}}{labels for the boundary and mutations combinations;
e.g., \code{c("cdr_r", "cdr_s", "fwr_r", "fwr_s")}.}

\item{\code{citation}}{publication source.}
}}

\seealso{
See \link{IMGT_SCHEMES} for a set of predefined \code{RegionDefinition} objects.
}
