% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test.R
\name{t_test}
\alias{t_test}
\title{Student's t test}
\usage{
t_test(
  data,
  select = NULL,
  by = NULL,
  weights = NULL,
  paired = FALSE,
  mu = 0,
  alternative = "two.sided"
)
}
\arguments{
\item{data}{A data frame.}

\item{select}{Name(s) of the continuous variable(s) (as character vector)
to be used as samples for the test. \code{select} can be one of the following:
\itemize{
\item \code{select} can be used in combination with \code{by}, in which case \code{select} is
the name of the continous variable (and \code{by} indicates a grouping factor).
\item \code{select} can also be a character vector of length two or more (more than
two names only apply to \code{kruskal_wallis_test()}), in which case the two
continuous variables are treated as samples to be compared. \code{by} must be
\code{NULL} in this case.
\item If \code{select} select is of length \strong{two} and \code{paired = TRUE}, the two samples
are considered as \emph{dependent} and a paired test is carried out.
\item If \code{select} specifies \strong{one} variable and \code{by = NULL}, a one-sample test
is carried out (only applicable for \code{t_test()} and \code{wilcoxon_test()})
\item For \code{chi_squared_test()}, if \code{select} specifies \strong{one} variable and
both \code{by} and \code{probabilities} are \code{NULL}, a one-sample test against given
probabilities is automatically conducted, with equal probabilities for
each level of \code{select}.
}}

\item{by}{Name of the variable indicating the groups. Required if \code{select}
specifies only one variable that contains all samples to be compared in the
test. If \code{by} is not a factor, it will be coerced to a factor. For
\code{chi_squared_test()}, if \code{probabilities} is provided, \code{by} must be \code{NULL}.}

\item{weights}{Name of an (optional) weighting variable to be used for the test.}

\item{paired}{Logical, whether to compute a paired t-test for dependent
samples.}

\item{mu}{The hypothesized difference in means (for \code{t_test()}) or location
shift (for \code{wilcoxon_test()} and \code{mann_whitney_test()}). The default is 0.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}. See \code{?t.test}
and \code{?wilcox.test}.}
}
\value{
A data frame with test results. Effectsize Cohen's \emph{d} is returned
for larger samples (n > 20), while Hedges' \emph{g} is returned for smaller samples.
}
\description{
This function performs a Student's t test for two independent
samples, for paired samples, or for one sample. It's a parametric test for
the null hypothesis that the means of two independent samples are equal, or
that the mean of one sample is equal to a specified value. The hypothesis
can be one- or two-sided.

Unlike the underlying base R function \code{t.test()}, this function allows for
weighted tests and automatically calculates effect sizes. Cohen's \emph{d} is
returned for larger samples (n > 20), while Hedges' \emph{g} is returned for
smaller samples.
}
\details{
Interpretation of effect sizes are based on rules described in
\code{\link[effectsize:interpret_cohens_d]{effectsize::interpret_cohens_d()}} and \code{\link[effectsize:interpret_cohens_d]{effectsize::interpret_hedges_g()}}.
Use these function directly to get other interpretations, by providing the
returned effect size (\emph{Cohen's d} or \emph{Hedges's g} in this case) as argument,
e.g. \code{interpret_cohens_d(0.35, rules = "sawilowsky2009")}.
}
\section{Which test to use}{

The following table provides an overview of which test to use for different
types of data. The choice of test depends on the scale of the outcome
variable and the number of samples to compare.\tabular{lll}{
   \strong{Samples} \tab \strong{Scale of Outcome} \tab \strong{Significance Test} \cr
   1 \tab binary / nominal \tab \code{chi_squared_test()} \cr
   1 \tab continuous, not normal \tab \code{wilcoxon_test()} \cr
   1 \tab continuous, normal \tab \code{t_test()} \cr
   2, independent \tab binary / nominal \tab \code{chi_squared_test()} \cr
   2, independent \tab continuous, not normal \tab \code{mann_whitney_test()} \cr
   2, independent \tab continuous, normal \tab \code{t_test()} \cr
   2, dependent \tab binary (only 2x2) \tab \code{chi_squared_test(paired=TRUE)} \cr
   2, dependent \tab continuous, not normal \tab \code{wilcoxon_test()} \cr
   2, dependent \tab continuous, normal \tab \code{t_test(paired=TRUE)} \cr
   >2, independent \tab continuous, not normal \tab \code{kruskal_wallis_test()} \cr
   >2, independent \tab continuous,     normal \tab \code{datawizard::means_by_group()} \cr
   >2, dependent \tab continuous, not normal \tab \emph{not yet implemented} (1) \cr
   >2, dependent \tab continuous,     normal \tab \emph{not yet implemented} (2) \cr
}


(1) More than two dependent samples are considered as \emph{repeated measurements}.
For ordinal or not-normally distributed outcomes, these samples are
usually tested using a \code{\link[=friedman.test]{friedman.test()}}, which requires the samples
in one variable, the groups to compare in another variable, and a third
variable indicating the repeated measurements (subject IDs).

(2) More than two dependent samples are considered as \emph{repeated measurements}.
For normally distributed outcomes, these samples are usually tested using
a ANOVA for repeated measurements. A more sophisticated approach would
be using a linear mixed model.
}

\examples{
\dontshow{if (requireNamespace("effectsize")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(sleep)
# one-sample t-test
t_test(sleep, "extra")
# base R equivalent
t.test(extra ~ 1, data = sleep)

# two-sample t-test, by group
t_test(mtcars, "mpg", by = "am")
# base R equivalent
t.test(mpg ~ am, data = mtcars)

# paired t-test
t_test(mtcars, c("mpg", "hp"), paired = TRUE)
# base R equivalent
t.test(mtcars$mpg, mtcars$hp, data = mtcars, paired = TRUE)
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Bender, R., Lange, S., Ziegler, A. Wichtige Signifikanztests.
Dtsch Med Wochenschr 2007; 132: e24–e25
\item du Prel, J.B., Röhrig, B., Hommel, G., Blettner, M. Auswahl statistischer
Testverfahren. Dtsch Arztebl Int 2010; 107(19): 343–8
}
}
\seealso{
\itemize{
\item \code{\link[=t_test]{t_test()}} for parametric t-tests of dependent and independent samples.
\item \code{\link[=mann_whitney_test]{mann_whitney_test()}} for non-parametric tests of unpaired (independent)
samples.
\item \code{\link[=wilcoxon_test]{wilcoxon_test()}} for Wilcoxon rank sum tests for non-parametric tests
of paired (dependent) samples.
\item \code{\link[=kruskal_wallis_test]{kruskal_wallis_test()}} for non-parametric tests with more than two
independent samples.
\item \code{\link[=chi_squared_test]{chi_squared_test()}} for chi-squared tests (two categorical variables,
dependent and independent).
}
}
