---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, page, page de gauche, page de droite, recto, verso
---

# Comment savoir si une page est un recto ou un verso ?

Parfois, il est important de savoir où un morceau de texte va se retrouver une fois mise en forme, 
comme par exemple savoir si un texte est disposé sur un recto ou un verso. 
La question "[](/3_composition/texte/pages/notes_marginales/mettre_des_notes_marginales_a_droite)" 
illustre ce sujet avec le positionnement des notes marginales.

La difficulté de ce sujet a pour origine la routine de sortie (qui produit les pages composées) de TeX et LaTeX :
ces derniers vont traiter une bonne partie de la page suivante avant de déterminer où découper la page présente. 
Par conséquent, le compteur `page` (nommé dans LaTeX `\c@page`) 
n'a de fiabilité qu’*au moment* du traitement de la routine de sortie. 
Cette situation est illustrée dans la question "[](numerotation_des_pages/le_numero_de_page_est_incorrect)".

La solution revient :

- à utiliser une version du mécanisme de `\label` pour déterminer sur quelle page vous êtes ;
- et à intégrer le fait que la valeur du compteur de page apparaissant 
  dans une commande `\pageref` est insérée lors de la routine de sortie, ce qui la rend fiable.

Toutefois... `\pageref` elle-même n'est pas fiable ! En toute logique, l'instruction

```{noedit}
\ifthenelse{\isodd{\pageref{foo}}}{...recto...}{...verso...}
```

aurait normalement du faire le nécessaire mais les extensions <ctanpkg:babel> 
et <ctanpkg:hyperref> sont toutes deux connues pour interférer avec la valeur de `\pageref`. 
Soyez donc prudent !


## Avec l'extension <ctanpkg:changepage>

L'extension <ctanpkg:changepage>, pour définir certaines de ses propres fonctionnalités, 
fournit une commande `\checkoddpage` : elle définit une "étiquette" pour son propre usage 
et l'élément de référence à la page de cette étiquette est ensuite examinée 
(<ctanpkg:hyperref> ne pouvant la parasiter) afin de définir une variable conditionnelle `\ifoddpage` vraie 
si la commande a été émise sur un recto. 

Les utilisateurs de LaTeX qui ne sont pas familiers avec les commandes `\if...` 
de TeX peuvent utiliser l'extension <ctanpkg:ifthen> :

```{noedit}
\usepackage{ifthen,changepage}
...
\checkoddpage
\ifthenelse{\boolean{oddpage}}{...recto...}{...verso...}
```

Bien sûr, ces nouvelles "étiquettes" contribuent à alimenter les messages d'erreur "Rerun to get cross-references"
(autrement dit "Relancer le programme pour mettre à jour les références croisées") de LaTeX...


## Avec la classe <ctanpkg:memoir>

La classe <ctanpkg:memoir> propose d'ailleurs la même commande que <ctanpkg:changepage>.


## Avec les classes [KOMA-Script](ctanpkg:koma-script)

Les classes [KOMA-Script](ctanpkg:koma-script) ont un environnement `addmargin*` 
qui fournit des fonctionnalités similaires à celles qu'offre <ctanpkg:changepage>. 
La commande `\ifthispageodd{...recto...}{...verso...}` permet ici d'exécuter différentes tâches selon le numéro de page 
[documentation en français pour KOMA-Script](/1_generalites/documentation/documents/documents_extensions/koma-script_en_francais)).


## Avec l'extension <ctanpkg:ifoddpage>

L'extension <ctanpkg:ifoddpage>, de Martin Scharrer, est conçue pour fournir une fonctionnalité identique. 
Elle se comporte en tenant compte du fait que vous composez un document recto-verso ou recto uniquement. 
Comme l'extension <ctanpkg:changepage>, elle utilise une commande de vérification nommée `\checkoddpage`. 
Les autres commandes de tests sont définies en utilisant des commandes conditionnelles de (Plain) TeX ; 
elles sont définis localement, afin que vous puissiez minimiser leur utilisation de l'espace de travail de TeX. 
La documentation de l'extension détaille la délicate séquence impliquée. 
De plus, l'extension fournit une commande `\ifoddpageoroneside`, 
qui est vraie pour les pages de droite d'un document recto-verso, ou sur toutes les pages d'un document recto.

L'utilisation de cette extension se limite généralement à :

```{noedit}
\checkoddpage
\ifoddpage
  ...recto...
\else
  ...verso...
\fi
```

Le principe recommandé par l'auteur de l'extension consiste à inclure toute l'opération dans une boîte. 
Cela présente l'avantage d'avoir un test qui fonctionne toujours 
mais cette technique a aussi le désavantage des boîtes (un bloc ne pouvant se scinder). 
Dans la pratique, l'ensemble du travail sera réalisé à l'intérieur d'une boîte 
(comme, par exemple, dans le cas d'un flottant) : ainsi, le travail élaboré proposé par l'auteur ne sera pas nécessaire.

:::{sources}
[Finding if you're on an odd or an even page](faquk:FAQ-oddpage)
:::