---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, polices, tailles de polices, 
              agrandir la police, réduire la police, taille relative
---

# Comment réaliser des changements de taille de fonte relatifs ?

## Avec l'extension <ctanpkg:relsize>

L'extension <ctanpkg:relsize> met à disposition une commande `\relsize{⟨n⟩}` 
qui permet d'augmenter (`⟨n⟩` positif) ou de diminuer (`⟨n⟩` négatif) 
la taille de la fonte par rapport à la taille courante.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{relsize}

\begin{document}
Un \relsize{1}texte \relsize{2}de \relsize{3}%
toutes \relsize{-1}les \relsize{-4}tailles.
\end{document}
```

Quelques autres commandes sont définies :

- `\smaller` est équivalent à `\relsize{-1}` ;
- `\larger` est équivalent à `\relsize{1}` ;
- `\textsmaller{texte}` agit sur le seul *texte* ;
- `\textlarger{texte}`agit sur le seul *texte* ;
- `\mathsmaller{A}` ;
- `\mathlarger{B}`.


## Avec l'extension <ctanpkg:scalefnt>

L'extension <ctanpkg:scalefnt>, de David Carlisle, permet d'augmenter ou de diminuer, 
suivant un *facteur* de proportion, 
la taille de la police courante avec la commande `\scalefont{⟨facteur⟩}`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{scalefnt}

\begin{document}
La taille initiale, \scalefont{2}le double la taille courante, 
\scalefont{.75}les trois quarts la taille courante 
(plus grande donc que la taille initiale).
\end{document}
```
