/*	$NetBSD: run-caljulian.c,v 1.1.1.3.8.2 2015/11/08 01:51:16 riz Exp $	*/

/* AUTOGENERATED FILE. DO NOT EDIT. */

//=======Test Runner Used To Run Each Test Below=====
#define RUN_TEST(TestFunc, TestLineNum) \
{ \
  Unity.CurrentTestName = #TestFunc; \
  Unity.CurrentTestLineNumber = TestLineNum; \
  Unity.NumberOfTests++; \
  if (TEST_PROTECT()) \
  { \
      setUp(); \
      TestFunc(); \
  } \
  if (TEST_PROTECT() && !TEST_IS_IGNORED) \
  { \
    tearDown(); \
  } \
  UnityConcludeTest(); \
}

//=======Automagically Detected Files To Include=====
#include "unity.h"
#include <setjmp.h>
#include <stdio.h>
#include "config.h"
#include "ntp_calendar.h"
#include "ntp_stdlib.h"
#include "test-libntp.h"
#include <string.h>

//=======External Functions This Runner Calls=====
extern void setUp(void);
extern void tearDown(void);
extern void test_RegularTime(void);
extern void test_LeapYear(void);
extern void test_uLongBoundary(void);
extern void test_uLongWrapped(void);


//=======Test Reset Option=====
void resetTest(void);
void resetTest(void)
{
  tearDown();
  setUp();
}

char const *progname;


//=======MAIN=====
int main(int argc, char *argv[])
{
  progname = argv[0];
  UnityBegin("caljulian.c");
  RUN_TEST(test_RegularTime, 16);
  RUN_TEST(test_LeapYear, 17);
  RUN_TEST(test_uLongBoundary, 18);
  RUN_TEST(test_uLongWrapped, 19);

  return (UnityEnd());
}
