/*	$NetBSD: run-clocktime.c,v 1.1.1.3.8.2 2015/11/08 01:51:16 riz Exp $	*/

/* AUTOGENERATED FILE. DO NOT EDIT. */

//=======Test Runner Used To Run Each Test Below=====
#define RUN_TEST(TestFunc, TestLineNum) \
{ \
  Unity.CurrentTestName = #TestFunc; \
  Unity.CurrentTestLineNumber = TestLineNum; \
  Unity.NumberOfTests++; \
  if (TEST_PROTECT()) \
  { \
      setUp(); \
      TestFunc(); \
  } \
  if (TEST_PROTECT() && !TEST_IS_IGNORED) \
  { \
    tearDown(); \
  } \
  UnityConcludeTest(); \
}

//=======Automagically Detected Files To Include=====
#include "unity.h"
#include <setjmp.h>
#include <stdio.h>
#include "config.h"
#include "ntp_calendar.h"
#include "ntp_stdlib.h"
#include "test-libntp.h"

//=======External Functions This Runner Calls=====
extern void setUp(void);
extern void tearDown(void);
extern void test_CurrentYear(void);
extern void test_CurrentYearFuzz(void);
extern void test_TimeZoneOffset(void);
extern void test_WrongYearStart(void);
extern void test_PreviousYear(void);
extern void test_NextYear(void);
extern void test_NoReasonableConversion(void);
extern void test_AlwaysInLimit(void);


//=======Test Reset Option=====
void resetTest(void);
void resetTest(void)
{
  tearDown();
  setUp();
}

char const *progname;


//=======MAIN=====
int main(int argc, char *argv[])
{
  progname = argv[0];
  UnityBegin("clocktime.c");
  RUN_TEST(test_CurrentYear, 11);
  RUN_TEST(test_CurrentYearFuzz, 12);
  RUN_TEST(test_TimeZoneOffset, 13);
  RUN_TEST(test_WrongYearStart, 14);
  RUN_TEST(test_PreviousYear, 15);
  RUN_TEST(test_NextYear, 16);
  RUN_TEST(test_NoReasonableConversion, 17);
  RUN_TEST(test_AlwaysInLimit, 19);

  return (UnityEnd());
}
